package io.debezium.operator.api.model.source.storage.schema;

import io.debezium.operator.api.model.source.storage.RedisStoreWaitConfig;
import io.debezium.operator.api.model.source.storage.RedisStoreWaitConfigFluent;
import io.debezium.operator.api.model.ConfigProperties;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.debezium.operator.api.model.source.storage.RedisStoreWaitConfigBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RedisSchemaHistoryStoreFluent<A extends RedisSchemaHistoryStoreFluent<A>> extends BaseFluent<A>{
  public RedisSchemaHistoryStoreFluent() {
  }
  
  public RedisSchemaHistoryStoreFluent(RedisSchemaHistoryStore instance) {
    this.copyInstance(instance);
  }
  private String address;
  private String user;
  private String password;
  private boolean sslEnabled;
  private String key;
  private RedisStoreWaitConfigBuilder wait;
  private ConfigProperties config;
  
  protected void copyInstance(RedisSchemaHistoryStore instance) {
    instance = (instance != null ? instance : new RedisSchemaHistoryStore());
    if (instance != null) {
          this.withAddress(instance.getAddress());
          this.withUser(instance.getUser());
          this.withPassword(instance.getPassword());
          this.withSslEnabled(instance.isSslEnabled());
          this.withKey(instance.getKey());
          this.withWait(instance.getWait());
          this.withConfig(instance.getConfig());
        }
  }
  
  public String getAddress() {
    return this.address;
  }
  
  public A withAddress(String address) {
    this.address = address;
    return (A) this;
  }
  
  public boolean hasAddress() {
    return this.address != null;
  }
  
  public String getUser() {
    return this.user;
  }
  
  public A withUser(String user) {
    this.user = user;
    return (A) this;
  }
  
  public boolean hasUser() {
    return this.user != null;
  }
  
  public String getPassword() {
    return this.password;
  }
  
  public A withPassword(String password) {
    this.password = password;
    return (A) this;
  }
  
  public boolean hasPassword() {
    return this.password != null;
  }
  
  public boolean isSslEnabled() {
    return this.sslEnabled;
  }
  
  public A withSslEnabled(boolean sslEnabled) {
    this.sslEnabled = sslEnabled;
    return (A) this;
  }
  
  public boolean hasSslEnabled() {
    return true;
  }
  
  public String getKey() {
    return this.key;
  }
  
  public A withKey(String key) {
    this.key = key;
    return (A) this;
  }
  
  public boolean hasKey() {
    return this.key != null;
  }
  
  public RedisStoreWaitConfig buildWait() {
    return this.wait != null ? this.wait.build() : null;
  }
  
  public A withWait(RedisStoreWaitConfig wait) {
    this._visitables.remove("wait");
    if (wait != null) {
        this.wait = new RedisStoreWaitConfigBuilder(wait);
        this._visitables.get("wait").add(this.wait);
    } else {
        this.wait = null;
        this._visitables.get("wait").remove(this.wait);
    }
    return (A) this;
  }
  
  public boolean hasWait() {
    return this.wait != null;
  }
  
  public WaitNested<A> withNewWait() {
    return new WaitNested(null);
  }
  
  public WaitNested<A> withNewWaitLike(RedisStoreWaitConfig item) {
    return new WaitNested(item);
  }
  
  public WaitNested<A> editWait() {
    return withNewWaitLike(java.util.Optional.ofNullable(buildWait()).orElse(null));
  }
  
  public WaitNested<A> editOrNewWait() {
    return withNewWaitLike(java.util.Optional.ofNullable(buildWait()).orElse(new RedisStoreWaitConfigBuilder().build()));
  }
  
  public WaitNested<A> editOrNewWaitLike(RedisStoreWaitConfig item) {
    return withNewWaitLike(java.util.Optional.ofNullable(buildWait()).orElse(item));
  }
  
  public ConfigProperties getConfig() {
    return this.config;
  }
  
  public A withConfig(ConfigProperties config) {
    this.config = config;
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RedisSchemaHistoryStoreFluent that = (RedisSchemaHistoryStoreFluent) o;
    if (!java.util.Objects.equals(address, that.address)) return false;
    if (!java.util.Objects.equals(user, that.user)) return false;
    if (!java.util.Objects.equals(password, that.password)) return false;
    if (sslEnabled != that.sslEnabled) return false;
    if (!java.util.Objects.equals(key, that.key)) return false;
    if (!java.util.Objects.equals(wait, that.wait)) return false;
    if (!java.util.Objects.equals(config, that.config)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(address,  user,  password,  sslEnabled,  key,  wait,  config,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    sb.append("sslEnabled:"); sb.append(sslEnabled + ",");
    if (key != null) { sb.append("key:"); sb.append(key + ","); }
    if (wait != null) { sb.append("wait:"); sb.append(wait + ","); }
    if (config != null) { sb.append("config:"); sb.append(config); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSslEnabled() {
    return withSslEnabled(true);
  }
  public class WaitNested<N> extends RedisStoreWaitConfigFluent<WaitNested<N>> implements Nested<N>{
    WaitNested(RedisStoreWaitConfig item) {
      this.builder = new RedisStoreWaitConfigBuilder(this, item);
    }
    RedisStoreWaitConfigBuilder builder;
    
    public N and() {
      return (N) RedisSchemaHistoryStoreFluent.this.withWait(builder.build());
    }
    
    public N endWait() {
      return and();
    }
    
  
  }

}