package io.debezium.operator.api.model.source.storage.offset;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RedisOffsetStoreBuilder extends RedisOffsetStoreFluent<RedisOffsetStoreBuilder> implements VisitableBuilder<RedisOffsetStore,RedisOffsetStoreBuilder>{
  public RedisOffsetStoreBuilder() {
    this(new RedisOffsetStore());
  }
  
  public RedisOffsetStoreBuilder(RedisOffsetStoreFluent<?> fluent) {
    this(fluent, new RedisOffsetStore());
  }
  
  public RedisOffsetStoreBuilder(RedisOffsetStoreFluent<?> fluent,RedisOffsetStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RedisOffsetStoreBuilder(RedisOffsetStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RedisOffsetStoreFluent<?> fluent;
  
  public RedisOffsetStore build() {
    RedisOffsetStore buildable = new RedisOffsetStore();
    buildable.setAddress(fluent.getAddress());
    buildable.setUser(fluent.getUser());
    buildable.setPassword(fluent.getPassword());
    buildable.setSslEnabled(fluent.isSslEnabled());
    buildable.setKey(fluent.getKey());
    buildable.setWait(fluent.buildWait());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}