package io.debezium.operator.api.model.source;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SchemaHistoryBuilder extends SchemaHistoryFluent<SchemaHistoryBuilder> implements VisitableBuilder<SchemaHistory,SchemaHistoryBuilder>{
  public SchemaHistoryBuilder() {
    this(new SchemaHistory());
  }
  
  public SchemaHistoryBuilder(SchemaHistoryFluent<?> fluent) {
    this(fluent, new SchemaHistory());
  }
  
  public SchemaHistoryBuilder(SchemaHistoryFluent<?> fluent,SchemaHistory instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SchemaHistoryBuilder(SchemaHistory instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SchemaHistoryFluent<?> fluent;
  
  public SchemaHistory build() {
    SchemaHistory buildable = new SchemaHistory();
    buildable.setFile(fluent.buildFile());
    buildable.setMemory(fluent.buildMemory());
    buildable.setRedis(fluent.buildRedis());
    buildable.setStore(fluent.buildStore());
    return buildable;
  }
  

}