package io.debezium.operator.api.model.runtime.storage;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DataStorageFluent<A extends DataStorageFluent<A>> extends BaseFluent<A>{
  public DataStorageFluent() {
  }
  
  public DataStorageFluent(DataStorage instance) {
    this.copyInstance(instance);
  }
  private StorageType type;
  private String claimName;
  
  protected void copyInstance(DataStorage instance) {
    instance = (instance != null ? instance : new DataStorage());
    if (instance != null) {
          this.withType(instance.getType());
          this.withClaimName(instance.getClaimName());
        }
  }
  
  public StorageType getType() {
    return this.type;
  }
  
  public A withType(StorageType type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public String getClaimName() {
    return this.claimName;
  }
  
  public A withClaimName(String claimName) {
    this.claimName = claimName;
    return (A) this;
  }
  
  public boolean hasClaimName() {
    return this.claimName != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DataStorageFluent that = (DataStorageFluent) o;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(claimName, that.claimName)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(type,  claimName,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (claimName != null) { sb.append("claimName:"); sb.append(claimName); }
    sb.append("}");
    return sb.toString();
  }
  

}