package io.debezium.operator.api.model.runtime.metrics;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JmxExporterFluent<A extends JmxExporterFluent<A>> extends BaseFluent<A>{
  public JmxExporterFluent() {
  }
  
  public JmxExporterFluent(JmxExporter instance) {
    this.copyInstance(instance);
  }
  private boolean enabled;
  private ConfigMapKeySelector configFrom;
  
  protected void copyInstance(JmxExporter instance) {
    instance = (instance != null ? instance : new JmxExporter());
    if (instance != null) {
          this.withEnabled(instance.isEnabled());
          this.withConfigFrom(instance.getConfigFrom());
        }
  }
  
  public boolean isEnabled() {
    return this.enabled;
  }
  
  public A withEnabled(boolean enabled) {
    this.enabled = enabled;
    return (A) this;
  }
  
  public boolean hasEnabled() {
    return true;
  }
  
  public ConfigMapKeySelector getConfigFrom() {
    return this.configFrom;
  }
  
  public A withConfigFrom(ConfigMapKeySelector configFrom) {
    this.configFrom = configFrom;
    return (A) this;
  }
  
  public boolean hasConfigFrom() {
    return this.configFrom != null;
  }
  
  public A withNewConfigFrom(String arg1,String arg2,Boolean arg3) {
    return (A)withConfigFrom(new ConfigMapKeySelector(arg1, arg2, arg3));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JmxExporterFluent that = (JmxExporterFluent) o;
    if (enabled != that.enabled) return false;
    if (!java.util.Objects.equals(configFrom, that.configFrom)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(enabled,  configFrom,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("enabled:"); sb.append(enabled + ",");
    if (configFrom != null) { sb.append("configFrom:"); sb.append(configFrom); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnabled() {
    return withEnabled(true);
  }
  

}