package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PredicateBuilder extends PredicateFluent<PredicateBuilder> implements VisitableBuilder<Predicate,PredicateBuilder>{
  public PredicateBuilder() {
    this(new Predicate());
  }
  
  public PredicateBuilder(PredicateFluent<?> fluent) {
    this(fluent, new Predicate());
  }
  
  public PredicateBuilder(PredicateFluent<?> fluent,Predicate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PredicateBuilder(Predicate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PredicateFluent<?> fluent;
  
  public Predicate build() {
    Predicate buildable = new Predicate();
    buildable.setType(fluent.getType());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}