package io.debezium.operator.api.model.source.storage.schema;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FileSchemaHistoryStoreBuilder extends FileSchemaHistoryStoreFluent<FileSchemaHistoryStoreBuilder> implements VisitableBuilder<FileSchemaHistoryStore,FileSchemaHistoryStoreBuilder>{
  public FileSchemaHistoryStoreBuilder() {
    this(new FileSchemaHistoryStore());
  }
  
  public FileSchemaHistoryStoreBuilder(FileSchemaHistoryStoreFluent<?> fluent) {
    this(fluent, new FileSchemaHistoryStore());
  }
  
  public FileSchemaHistoryStoreBuilder(FileSchemaHistoryStoreFluent<?> fluent,FileSchemaHistoryStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FileSchemaHistoryStoreBuilder(FileSchemaHistoryStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FileSchemaHistoryStoreFluent<?> fluent;
  
  public FileSchemaHistoryStore build() {
    FileSchemaHistoryStore buildable = new FileSchemaHistoryStore();
    buildable.setFileName(fluent.getFileName());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}