package io.debezium.operator.api.model.source.storage;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RedisStoreWaitConfigFluent<A extends RedisStoreWaitConfigFluent<A>> extends BaseFluent<A>{
  public RedisStoreWaitConfigFluent() {
  }
  
  public RedisStoreWaitConfigFluent(RedisStoreWaitConfig instance) {
    this.copyInstance(instance);
  }
  private boolean enabled;
  private long timeoutMs;
  private boolean retry;
  private long retryDelayMs;
  
  protected void copyInstance(RedisStoreWaitConfig instance) {
    instance = (instance != null ? instance : new RedisStoreWaitConfig());
    if (instance != null) {
          this.withEnabled(instance.isEnabled());
          this.withTimeoutMs(instance.getTimeoutMs());
          this.withRetry(instance.isRetry());
          this.withRetryDelayMs(instance.getRetryDelayMs());
        }
  }
  
  public boolean isEnabled() {
    return this.enabled;
  }
  
  public A withEnabled(boolean enabled) {
    this.enabled = enabled;
    return (A) this;
  }
  
  public boolean hasEnabled() {
    return true;
  }
  
  public long getTimeoutMs() {
    return this.timeoutMs;
  }
  
  public A withTimeoutMs(long timeoutMs) {
    this.timeoutMs = timeoutMs;
    return (A) this;
  }
  
  public boolean hasTimeoutMs() {
    return true;
  }
  
  public boolean isRetry() {
    return this.retry;
  }
  
  public A withRetry(boolean retry) {
    this.retry = retry;
    return (A) this;
  }
  
  public boolean hasRetry() {
    return true;
  }
  
  public long getRetryDelayMs() {
    return this.retryDelayMs;
  }
  
  public A withRetryDelayMs(long retryDelayMs) {
    this.retryDelayMs = retryDelayMs;
    return (A) this;
  }
  
  public boolean hasRetryDelayMs() {
    return true;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RedisStoreWaitConfigFluent that = (RedisStoreWaitConfigFluent) o;
    if (enabled != that.enabled) return false;
    if (timeoutMs != that.timeoutMs) return false;
    if (retry != that.retry) return false;
    if (retryDelayMs != that.retryDelayMs) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(enabled,  timeoutMs,  retry,  retryDelayMs,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("enabled:"); sb.append(enabled + ",");
    sb.append("timeoutMs:"); sb.append(timeoutMs + ",");
    sb.append("retry:"); sb.append(retry + ",");
    sb.append("retryDelayMs:"); sb.append(retryDelayMs);
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnabled() {
    return withEnabled(true);
  }
  
  public A withRetry() {
    return withRetry(true);
  }
  

}