package io.debezium.operator.api.model.source.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RedisStoreWaitConfigBuilder extends RedisStoreWaitConfigFluent<RedisStoreWaitConfigBuilder> implements VisitableBuilder<RedisStoreWaitConfig,RedisStoreWaitConfigBuilder>{
  public RedisStoreWaitConfigBuilder() {
    this(new RedisStoreWaitConfig());
  }
  
  public RedisStoreWaitConfigBuilder(RedisStoreWaitConfigFluent<?> fluent) {
    this(fluent, new RedisStoreWaitConfig());
  }
  
  public RedisStoreWaitConfigBuilder(RedisStoreWaitConfigFluent<?> fluent,RedisStoreWaitConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RedisStoreWaitConfigBuilder(RedisStoreWaitConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RedisStoreWaitConfigFluent<?> fluent;
  
  public RedisStoreWaitConfig build() {
    RedisStoreWaitConfig buildable = new RedisStoreWaitConfig();
    buildable.setEnabled(fluent.isEnabled());
    buildable.setTimeoutMs(fluent.getTimeoutMs());
    buildable.setRetry(fluent.isRetry());
    buildable.setRetryDelayMs(fluent.getRetryDelayMs());
    return buildable;
  }
  

}