package io.debezium.operator.api.model.source;

import io.debezium.operator.api.model.ConfigProperties;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SourceFluent<A extends SourceFluent<A>> extends BaseFluent<A>{
  public SourceFluent() {
  }
  
  public SourceFluent(Source instance) {
    this.copyInstance(instance);
  }
  private String sourceClass;
  private OffsetBuilder offset;
  private SchemaHistoryBuilder schemaHistory;
  private ConfigProperties config;
  
  protected void copyInstance(Source instance) {
    instance = (instance != null ? instance : new Source());
    if (instance != null) {
          this.withSourceClass(instance.getSourceClass());
          this.withOffset(instance.getOffset());
          this.withSchemaHistory(instance.getSchemaHistory());
          this.withConfig(instance.getConfig());
        }
  }
  
  public String getSourceClass() {
    return this.sourceClass;
  }
  
  public A withSourceClass(String sourceClass) {
    this.sourceClass = sourceClass;
    return (A) this;
  }
  
  public boolean hasSourceClass() {
    return this.sourceClass != null;
  }
  
  public Offset buildOffset() {
    return this.offset != null ? this.offset.build() : null;
  }
  
  public A withOffset(Offset offset) {
    this._visitables.remove("offset");
    if (offset != null) {
        this.offset = new OffsetBuilder(offset);
        this._visitables.get("offset").add(this.offset);
    } else {
        this.offset = null;
        this._visitables.get("offset").remove(this.offset);
    }
    return (A) this;
  }
  
  public boolean hasOffset() {
    return this.offset != null;
  }
  
  public OffsetNested<A> withNewOffset() {
    return new OffsetNested(null);
  }
  
  public OffsetNested<A> withNewOffsetLike(Offset item) {
    return new OffsetNested(item);
  }
  
  public OffsetNested<A> editOffset() {
    return withNewOffsetLike(java.util.Optional.ofNullable(buildOffset()).orElse(null));
  }
  
  public OffsetNested<A> editOrNewOffset() {
    return withNewOffsetLike(java.util.Optional.ofNullable(buildOffset()).orElse(new OffsetBuilder().build()));
  }
  
  public OffsetNested<A> editOrNewOffsetLike(Offset item) {
    return withNewOffsetLike(java.util.Optional.ofNullable(buildOffset()).orElse(item));
  }
  
  public SchemaHistory buildSchemaHistory() {
    return this.schemaHistory != null ? this.schemaHistory.build() : null;
  }
  
  public A withSchemaHistory(SchemaHistory schemaHistory) {
    this._visitables.remove("schemaHistory");
    if (schemaHistory != null) {
        this.schemaHistory = new SchemaHistoryBuilder(schemaHistory);
        this._visitables.get("schemaHistory").add(this.schemaHistory);
    } else {
        this.schemaHistory = null;
        this._visitables.get("schemaHistory").remove(this.schemaHistory);
    }
    return (A) this;
  }
  
  public boolean hasSchemaHistory() {
    return this.schemaHistory != null;
  }
  
  public SchemaHistoryNested<A> withNewSchemaHistory() {
    return new SchemaHistoryNested(null);
  }
  
  public SchemaHistoryNested<A> withNewSchemaHistoryLike(SchemaHistory item) {
    return new SchemaHistoryNested(item);
  }
  
  public SchemaHistoryNested<A> editSchemaHistory() {
    return withNewSchemaHistoryLike(java.util.Optional.ofNullable(buildSchemaHistory()).orElse(null));
  }
  
  public SchemaHistoryNested<A> editOrNewSchemaHistory() {
    return withNewSchemaHistoryLike(java.util.Optional.ofNullable(buildSchemaHistory()).orElse(new SchemaHistoryBuilder().build()));
  }
  
  public SchemaHistoryNested<A> editOrNewSchemaHistoryLike(SchemaHistory item) {
    return withNewSchemaHistoryLike(java.util.Optional.ofNullable(buildSchemaHistory()).orElse(item));
  }
  
  public ConfigProperties getConfig() {
    return this.config;
  }
  
  public A withConfig(ConfigProperties config) {
    this.config = config;
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SourceFluent that = (SourceFluent) o;
    if (!java.util.Objects.equals(sourceClass, that.sourceClass)) return false;
    if (!java.util.Objects.equals(offset, that.offset)) return false;
    if (!java.util.Objects.equals(schemaHistory, that.schemaHistory)) return false;
    if (!java.util.Objects.equals(config, that.config)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(sourceClass,  offset,  schemaHistory,  config,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sourceClass != null) { sb.append("sourceClass:"); sb.append(sourceClass + ","); }
    if (offset != null) { sb.append("offset:"); sb.append(offset + ","); }
    if (schemaHistory != null) { sb.append("schemaHistory:"); sb.append(schemaHistory + ","); }
    if (config != null) { sb.append("config:"); sb.append(config); }
    sb.append("}");
    return sb.toString();
  }
  public class OffsetNested<N> extends OffsetFluent<OffsetNested<N>> implements Nested<N>{
    OffsetNested(Offset item) {
      this.builder = new OffsetBuilder(this, item);
    }
    OffsetBuilder builder;
    
    public N and() {
      return (N) SourceFluent.this.withOffset(builder.build());
    }
    
    public N endOffset() {
      return and();
    }
    
  
  }
  public class SchemaHistoryNested<N> extends SchemaHistoryFluent<SchemaHistoryNested<N>> implements Nested<N>{
    SchemaHistoryNested(SchemaHistory item) {
      this.builder = new SchemaHistoryBuilder(this, item);
    }
    SchemaHistoryBuilder builder;
    
    public N and() {
      return (N) SourceFluent.this.withSchemaHistory(builder.build());
    }
    
    public N endSchemaHistory() {
      return and();
    }
    
  
  }

}