package io.debezium.operator.api.model.source;

import java.lang.SuppressWarnings;
import io.debezium.operator.api.model.source.storage.schema.InMemorySchemaHistoryStore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.debezium.operator.api.model.source.storage.schema.FileSchemaHistoryStore;
import java.lang.String;
import io.debezium.operator.api.model.source.storage.schema.FileSchemaHistoryStoreFluent;
import io.debezium.operator.api.model.source.storage.schema.RedisSchemaHistoryStore;
import io.debezium.operator.api.model.source.storage.schema.InMemorySchemaHistoryStoreBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.debezium.operator.api.model.source.storage.CustomStore;
import io.debezium.operator.api.model.source.storage.schema.RedisSchemaHistoryStoreBuilder;
import io.debezium.operator.api.model.source.storage.schema.FileSchemaHistoryStoreBuilder;
import io.debezium.operator.api.model.source.storage.schema.RedisSchemaHistoryStoreFluent;
import io.debezium.operator.api.model.source.storage.schema.InMemorySchemaHistoryStoreFluent;
import java.lang.Object;
import io.debezium.operator.api.model.source.storage.CustomStoreBuilder;
import io.debezium.operator.api.model.source.storage.CustomStoreFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SchemaHistoryFluent<A extends SchemaHistoryFluent<A>> extends BaseFluent<A>{
  public SchemaHistoryFluent() {
  }
  
  public SchemaHistoryFluent(SchemaHistory instance) {
    this.copyInstance(instance);
  }
  private FileSchemaHistoryStoreBuilder file;
  private InMemorySchemaHistoryStoreBuilder memory;
  private RedisSchemaHistoryStoreBuilder redis;
  private CustomStoreBuilder store;
  
  protected void copyInstance(SchemaHistory instance) {
    instance = (instance != null ? instance : new SchemaHistory());
    if (instance != null) {
          this.withFile(instance.getFile());
          this.withMemory(instance.getMemory());
          this.withRedis(instance.getRedis());
          this.withStore(instance.getStore());
        }
  }
  
  public FileSchemaHistoryStore buildFile() {
    return this.file != null ? this.file.build() : null;
  }
  
  public A withFile(FileSchemaHistoryStore file) {
    this._visitables.remove("file");
    if (file != null) {
        this.file = new FileSchemaHistoryStoreBuilder(file);
        this._visitables.get("file").add(this.file);
    } else {
        this.file = null;
        this._visitables.get("file").remove(this.file);
    }
    return (A) this;
  }
  
  public boolean hasFile() {
    return this.file != null;
  }
  
  public FileNested<A> withNewFile() {
    return new FileNested(null);
  }
  
  public FileNested<A> withNewFileLike(FileSchemaHistoryStore item) {
    return new FileNested(item);
  }
  
  public FileNested<A> editFile() {
    return withNewFileLike(java.util.Optional.ofNullable(buildFile()).orElse(null));
  }
  
  public FileNested<A> editOrNewFile() {
    return withNewFileLike(java.util.Optional.ofNullable(buildFile()).orElse(new FileSchemaHistoryStoreBuilder().build()));
  }
  
  public FileNested<A> editOrNewFileLike(FileSchemaHistoryStore item) {
    return withNewFileLike(java.util.Optional.ofNullable(buildFile()).orElse(item));
  }
  
  public InMemorySchemaHistoryStore buildMemory() {
    return this.memory != null ? this.memory.build() : null;
  }
  
  public A withMemory(InMemorySchemaHistoryStore memory) {
    this._visitables.remove("memory");
    if (memory != null) {
        this.memory = new InMemorySchemaHistoryStoreBuilder(memory);
        this._visitables.get("memory").add(this.memory);
    } else {
        this.memory = null;
        this._visitables.get("memory").remove(this.memory);
    }
    return (A) this;
  }
  
  public boolean hasMemory() {
    return this.memory != null;
  }
  
  public MemoryNested<A> withNewMemory() {
    return new MemoryNested(null);
  }
  
  public MemoryNested<A> withNewMemoryLike(InMemorySchemaHistoryStore item) {
    return new MemoryNested(item);
  }
  
  public MemoryNested<A> editMemory() {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(null));
  }
  
  public MemoryNested<A> editOrNewMemory() {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(new InMemorySchemaHistoryStoreBuilder().build()));
  }
  
  public MemoryNested<A> editOrNewMemoryLike(InMemorySchemaHistoryStore item) {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(item));
  }
  
  public RedisSchemaHistoryStore buildRedis() {
    return this.redis != null ? this.redis.build() : null;
  }
  
  public A withRedis(RedisSchemaHistoryStore redis) {
    this._visitables.remove("redis");
    if (redis != null) {
        this.redis = new RedisSchemaHistoryStoreBuilder(redis);
        this._visitables.get("redis").add(this.redis);
    } else {
        this.redis = null;
        this._visitables.get("redis").remove(this.redis);
    }
    return (A) this;
  }
  
  public boolean hasRedis() {
    return this.redis != null;
  }
  
  public RedisNested<A> withNewRedis() {
    return new RedisNested(null);
  }
  
  public RedisNested<A> withNewRedisLike(RedisSchemaHistoryStore item) {
    return new RedisNested(item);
  }
  
  public RedisNested<A> editRedis() {
    return withNewRedisLike(java.util.Optional.ofNullable(buildRedis()).orElse(null));
  }
  
  public RedisNested<A> editOrNewRedis() {
    return withNewRedisLike(java.util.Optional.ofNullable(buildRedis()).orElse(new RedisSchemaHistoryStoreBuilder().build()));
  }
  
  public RedisNested<A> editOrNewRedisLike(RedisSchemaHistoryStore item) {
    return withNewRedisLike(java.util.Optional.ofNullable(buildRedis()).orElse(item));
  }
  
  public CustomStore buildStore() {
    return this.store != null ? this.store.build() : null;
  }
  
  public A withStore(CustomStore store) {
    this._visitables.remove("store");
    if (store != null) {
        this.store = new CustomStoreBuilder(store);
        this._visitables.get("store").add(this.store);
    } else {
        this.store = null;
        this._visitables.get("store").remove(this.store);
    }
    return (A) this;
  }
  
  public boolean hasStore() {
    return this.store != null;
  }
  
  public StoreNested<A> withNewStore() {
    return new StoreNested(null);
  }
  
  public StoreNested<A> withNewStoreLike(CustomStore item) {
    return new StoreNested(item);
  }
  
  public StoreNested<A> editStore() {
    return withNewStoreLike(java.util.Optional.ofNullable(buildStore()).orElse(null));
  }
  
  public StoreNested<A> editOrNewStore() {
    return withNewStoreLike(java.util.Optional.ofNullable(buildStore()).orElse(new CustomStoreBuilder().build()));
  }
  
  public StoreNested<A> editOrNewStoreLike(CustomStore item) {
    return withNewStoreLike(java.util.Optional.ofNullable(buildStore()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SchemaHistoryFluent that = (SchemaHistoryFluent) o;
    if (!java.util.Objects.equals(file, that.file)) return false;
    if (!java.util.Objects.equals(memory, that.memory)) return false;
    if (!java.util.Objects.equals(redis, that.redis)) return false;
    if (!java.util.Objects.equals(store, that.store)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(file,  memory,  redis,  store,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (file != null) { sb.append("file:"); sb.append(file + ","); }
    if (memory != null) { sb.append("memory:"); sb.append(memory + ","); }
    if (redis != null) { sb.append("redis:"); sb.append(redis + ","); }
    if (store != null) { sb.append("store:"); sb.append(store); }
    sb.append("}");
    return sb.toString();
  }
  public class FileNested<N> extends FileSchemaHistoryStoreFluent<FileNested<N>> implements Nested<N>{
    FileNested(FileSchemaHistoryStore item) {
      this.builder = new FileSchemaHistoryStoreBuilder(this, item);
    }
    FileSchemaHistoryStoreBuilder builder;
    
    public N and() {
      return (N) SchemaHistoryFluent.this.withFile(builder.build());
    }
    
    public N endFile() {
      return and();
    }
    
  
  }
  public class MemoryNested<N> extends InMemorySchemaHistoryStoreFluent<MemoryNested<N>> implements Nested<N>{
    MemoryNested(InMemorySchemaHistoryStore item) {
      this.builder = new InMemorySchemaHistoryStoreBuilder(this, item);
    }
    InMemorySchemaHistoryStoreBuilder builder;
    
    public N and() {
      return (N) SchemaHistoryFluent.this.withMemory(builder.build());
    }
    
    public N endMemory() {
      return and();
    }
    
  
  }
  public class RedisNested<N> extends RedisSchemaHistoryStoreFluent<RedisNested<N>> implements Nested<N>{
    RedisNested(RedisSchemaHistoryStore item) {
      this.builder = new RedisSchemaHistoryStoreBuilder(this, item);
    }
    RedisSchemaHistoryStoreBuilder builder;
    
    public N and() {
      return (N) SchemaHistoryFluent.this.withRedis(builder.build());
    }
    
    public N endRedis() {
      return and();
    }
    
  
  }
  public class StoreNested<N> extends CustomStoreFluent<StoreNested<N>> implements Nested<N>{
    StoreNested(CustomStore item) {
      this.builder = new CustomStoreBuilder(this, item);
    }
    CustomStoreBuilder builder;
    
    public N and() {
      return (N) SchemaHistoryFluent.this.withStore(builder.build());
    }
    
    public N endStore() {
      return and();
    }
    
  
  }

}