package io.debezium.operator.api.model.source;

import io.debezium.operator.api.model.source.storage.offset.FileOffsetStoreBuilder;
import io.debezium.operator.api.model.source.storage.offset.RedisOffsetStoreFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.debezium.operator.api.model.source.storage.offset.InMemoryOffsetStoreBuilder;
import io.debezium.operator.api.model.source.storage.offset.InMemoryOffsetStoreFluent;
import io.debezium.operator.api.model.source.storage.offset.RedisOffsetStoreBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.debezium.operator.api.model.source.storage.CustomStore;
import io.debezium.operator.api.model.source.storage.offset.InMemoryOffsetStore;
import io.debezium.operator.api.model.source.storage.offset.FileOffsetStoreFluent;
import io.debezium.operator.api.model.source.storage.offset.FileOffsetStore;
import java.lang.Object;
import io.debezium.operator.api.model.source.storage.offset.RedisOffsetStore;
import io.debezium.operator.api.model.source.storage.CustomStoreBuilder;
import io.debezium.operator.api.model.source.storage.CustomStoreFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OffsetFluent<A extends OffsetFluent<A>> extends BaseFluent<A>{
  public OffsetFluent() {
  }
  
  public OffsetFluent(Offset instance) {
    this.copyInstance(instance);
  }
  private FileOffsetStoreBuilder file;
  private InMemoryOffsetStoreBuilder memory;
  private RedisOffsetStoreBuilder redis;
  private CustomStoreBuilder store;
  private long flushMs;
  
  protected void copyInstance(Offset instance) {
    instance = (instance != null ? instance : new Offset());
    if (instance != null) {
          this.withFile(instance.getFile());
          this.withMemory(instance.getMemory());
          this.withRedis(instance.getRedis());
          this.withStore(instance.getStore());
          this.withFlushMs(instance.getFlushMs());
        }
  }
  
  public FileOffsetStore buildFile() {
    return this.file != null ? this.file.build() : null;
  }
  
  public A withFile(FileOffsetStore file) {
    this._visitables.remove("file");
    if (file != null) {
        this.file = new FileOffsetStoreBuilder(file);
        this._visitables.get("file").add(this.file);
    } else {
        this.file = null;
        this._visitables.get("file").remove(this.file);
    }
    return (A) this;
  }
  
  public boolean hasFile() {
    return this.file != null;
  }
  
  public FileNested<A> withNewFile() {
    return new FileNested(null);
  }
  
  public FileNested<A> withNewFileLike(FileOffsetStore item) {
    return new FileNested(item);
  }
  
  public FileNested<A> editFile() {
    return withNewFileLike(java.util.Optional.ofNullable(buildFile()).orElse(null));
  }
  
  public FileNested<A> editOrNewFile() {
    return withNewFileLike(java.util.Optional.ofNullable(buildFile()).orElse(new FileOffsetStoreBuilder().build()));
  }
  
  public FileNested<A> editOrNewFileLike(FileOffsetStore item) {
    return withNewFileLike(java.util.Optional.ofNullable(buildFile()).orElse(item));
  }
  
  public InMemoryOffsetStore buildMemory() {
    return this.memory != null ? this.memory.build() : null;
  }
  
  public A withMemory(InMemoryOffsetStore memory) {
    this._visitables.remove("memory");
    if (memory != null) {
        this.memory = new InMemoryOffsetStoreBuilder(memory);
        this._visitables.get("memory").add(this.memory);
    } else {
        this.memory = null;
        this._visitables.get("memory").remove(this.memory);
    }
    return (A) this;
  }
  
  public boolean hasMemory() {
    return this.memory != null;
  }
  
  public MemoryNested<A> withNewMemory() {
    return new MemoryNested(null);
  }
  
  public MemoryNested<A> withNewMemoryLike(InMemoryOffsetStore item) {
    return new MemoryNested(item);
  }
  
  public MemoryNested<A> editMemory() {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(null));
  }
  
  public MemoryNested<A> editOrNewMemory() {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(new InMemoryOffsetStoreBuilder().build()));
  }
  
  public MemoryNested<A> editOrNewMemoryLike(InMemoryOffsetStore item) {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(item));
  }
  
  public RedisOffsetStore buildRedis() {
    return this.redis != null ? this.redis.build() : null;
  }
  
  public A withRedis(RedisOffsetStore redis) {
    this._visitables.remove("redis");
    if (redis != null) {
        this.redis = new RedisOffsetStoreBuilder(redis);
        this._visitables.get("redis").add(this.redis);
    } else {
        this.redis = null;
        this._visitables.get("redis").remove(this.redis);
    }
    return (A) this;
  }
  
  public boolean hasRedis() {
    return this.redis != null;
  }
  
  public RedisNested<A> withNewRedis() {
    return new RedisNested(null);
  }
  
  public RedisNested<A> withNewRedisLike(RedisOffsetStore item) {
    return new RedisNested(item);
  }
  
  public RedisNested<A> editRedis() {
    return withNewRedisLike(java.util.Optional.ofNullable(buildRedis()).orElse(null));
  }
  
  public RedisNested<A> editOrNewRedis() {
    return withNewRedisLike(java.util.Optional.ofNullable(buildRedis()).orElse(new RedisOffsetStoreBuilder().build()));
  }
  
  public RedisNested<A> editOrNewRedisLike(RedisOffsetStore item) {
    return withNewRedisLike(java.util.Optional.ofNullable(buildRedis()).orElse(item));
  }
  
  public CustomStore buildStore() {
    return this.store != null ? this.store.build() : null;
  }
  
  public A withStore(CustomStore store) {
    this._visitables.remove("store");
    if (store != null) {
        this.store = new CustomStoreBuilder(store);
        this._visitables.get("store").add(this.store);
    } else {
        this.store = null;
        this._visitables.get("store").remove(this.store);
    }
    return (A) this;
  }
  
  public boolean hasStore() {
    return this.store != null;
  }
  
  public StoreNested<A> withNewStore() {
    return new StoreNested(null);
  }
  
  public StoreNested<A> withNewStoreLike(CustomStore item) {
    return new StoreNested(item);
  }
  
  public StoreNested<A> editStore() {
    return withNewStoreLike(java.util.Optional.ofNullable(buildStore()).orElse(null));
  }
  
  public StoreNested<A> editOrNewStore() {
    return withNewStoreLike(java.util.Optional.ofNullable(buildStore()).orElse(new CustomStoreBuilder().build()));
  }
  
  public StoreNested<A> editOrNewStoreLike(CustomStore item) {
    return withNewStoreLike(java.util.Optional.ofNullable(buildStore()).orElse(item));
  }
  
  public long getFlushMs() {
    return this.flushMs;
  }
  
  public A withFlushMs(long flushMs) {
    this.flushMs = flushMs;
    return (A) this;
  }
  
  public boolean hasFlushMs() {
    return true;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OffsetFluent that = (OffsetFluent) o;
    if (!java.util.Objects.equals(file, that.file)) return false;
    if (!java.util.Objects.equals(memory, that.memory)) return false;
    if (!java.util.Objects.equals(redis, that.redis)) return false;
    if (!java.util.Objects.equals(store, that.store)) return false;
    if (flushMs != that.flushMs) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(file,  memory,  redis,  store,  flushMs,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (file != null) { sb.append("file:"); sb.append(file + ","); }
    if (memory != null) { sb.append("memory:"); sb.append(memory + ","); }
    if (redis != null) { sb.append("redis:"); sb.append(redis + ","); }
    if (store != null) { sb.append("store:"); sb.append(store + ","); }
    sb.append("flushMs:"); sb.append(flushMs);
    sb.append("}");
    return sb.toString();
  }
  public class FileNested<N> extends FileOffsetStoreFluent<FileNested<N>> implements Nested<N>{
    FileNested(FileOffsetStore item) {
      this.builder = new FileOffsetStoreBuilder(this, item);
    }
    FileOffsetStoreBuilder builder;
    
    public N and() {
      return (N) OffsetFluent.this.withFile(builder.build());
    }
    
    public N endFile() {
      return and();
    }
    
  
  }
  public class MemoryNested<N> extends InMemoryOffsetStoreFluent<MemoryNested<N>> implements Nested<N>{
    MemoryNested(InMemoryOffsetStore item) {
      this.builder = new InMemoryOffsetStoreBuilder(this, item);
    }
    InMemoryOffsetStoreBuilder builder;
    
    public N and() {
      return (N) OffsetFluent.this.withMemory(builder.build());
    }
    
    public N endMemory() {
      return and();
    }
    
  
  }
  public class RedisNested<N> extends RedisOffsetStoreFluent<RedisNested<N>> implements Nested<N>{
    RedisNested(RedisOffsetStore item) {
      this.builder = new RedisOffsetStoreBuilder(this, item);
    }
    RedisOffsetStoreBuilder builder;
    
    public N and() {
      return (N) OffsetFluent.this.withRedis(builder.build());
    }
    
    public N endRedis() {
      return and();
    }
    
  
  }
  public class StoreNested<N> extends CustomStoreFluent<StoreNested<N>> implements Nested<N>{
    StoreNested(CustomStore item) {
      this.builder = new CustomStoreBuilder(this, item);
    }
    CustomStoreBuilder builder;
    
    public N and() {
      return (N) OffsetFluent.this.withStore(builder.build());
    }
    
    public N endStore() {
      return and();
    }
    
  
  }

}