package io.debezium.operator.api.model.source;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OffsetBuilder extends OffsetFluent<OffsetBuilder> implements VisitableBuilder<Offset,OffsetBuilder>{
  public OffsetBuilder() {
    this(new Offset());
  }
  
  public OffsetBuilder(OffsetFluent<?> fluent) {
    this(fluent, new Offset());
  }
  
  public OffsetBuilder(OffsetFluent<?> fluent,Offset instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OffsetBuilder(Offset instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OffsetFluent<?> fluent;
  
  public Offset build() {
    Offset buildable = new Offset();
    buildable.setFile(fluent.buildFile());
    buildable.setMemory(fluent.buildMemory());
    buildable.setRedis(fluent.buildRedis());
    buildable.setStore(fluent.buildStore());
    buildable.setFlushMs(fluent.getFlushMs());
    return buildable;
  }
  

}