package io.debezium.operator.api.model.runtime.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DataStorageBuilder extends DataStorageFluent<DataStorageBuilder> implements VisitableBuilder<DataStorage,DataStorageBuilder>{
  public DataStorageBuilder() {
    this(new DataStorage());
  }
  
  public DataStorageBuilder(DataStorageFluent<?> fluent) {
    this(fluent, new DataStorage());
  }
  
  public DataStorageBuilder(DataStorageFluent<?> fluent,DataStorage instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DataStorageBuilder(DataStorage instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DataStorageFluent<?> fluent;
  
  public DataStorage build() {
    DataStorage buildable = new DataStorage();
    buildable.setType(fluent.getType());
    buildable.setClaimName(fluent.getClaimName());
    return buildable;
  }
  

}