package io.debezium.operator.api.model.runtime.metrics;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MetricsBuilder extends MetricsFluent<MetricsBuilder> implements VisitableBuilder<Metrics,MetricsBuilder>{
  public MetricsBuilder() {
    this(new Metrics());
  }
  
  public MetricsBuilder(MetricsFluent<?> fluent) {
    this(fluent, new Metrics());
  }
  
  public MetricsBuilder(MetricsFluent<?> fluent,Metrics instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MetricsBuilder(Metrics instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MetricsFluent<?> fluent;
  
  public Metrics build() {
    Metrics buildable = new Metrics();
    buildable.setJmxExporter(fluent.buildJmxExporter());
    return buildable;
  }
  

}