package io.debezium.operator.api.model.runtime.metrics;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JmxExporterBuilder extends JmxExporterFluent<JmxExporterBuilder> implements VisitableBuilder<JmxExporter,JmxExporterBuilder>{
  public JmxExporterBuilder() {
    this(new JmxExporter());
  }
  
  public JmxExporterBuilder(JmxExporterFluent<?> fluent) {
    this(fluent, new JmxExporter());
  }
  
  public JmxExporterBuilder(JmxExporterFluent<?> fluent,JmxExporter instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JmxExporterBuilder(JmxExporter instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JmxExporterFluent<?> fluent;
  
  public JmxExporter build() {
    JmxExporter buildable = new JmxExporter();
    buildable.setEnabled(fluent.isEnabled());
    buildable.setConfigFrom(fluent.getConfigFrom());
    return buildable;
  }
  

}