package io.debezium.operator.api.model.runtime.jmx;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JmxAuthenticationBuilder extends JmxAuthenticationFluent<JmxAuthenticationBuilder> implements VisitableBuilder<JmxAuthentication,JmxAuthenticationBuilder>{
  public JmxAuthenticationBuilder() {
    this(new JmxAuthentication());
  }
  
  public JmxAuthenticationBuilder(JmxAuthenticationFluent<?> fluent) {
    this(fluent, new JmxAuthentication());
  }
  
  public JmxAuthenticationBuilder(JmxAuthenticationFluent<?> fluent,JmxAuthentication instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JmxAuthenticationBuilder(JmxAuthentication instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JmxAuthenticationFluent<?> fluent;
  
  public JmxAuthentication build() {
    JmxAuthentication buildable = new JmxAuthentication();
    buildable.setEnabled(fluent.isEnabled());
    buildable.setSecret(fluent.getSecret());
    buildable.setAccessFile(fluent.getAccessFile());
    buildable.setPasswordFile(fluent.getPasswordFile());
    return buildable;
  }
  

}