package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FormatBuilder extends FormatFluent<FormatBuilder> implements VisitableBuilder<Format,FormatBuilder>{
  public FormatBuilder() {
    this(new Format());
  }
  
  public FormatBuilder(FormatFluent<?> fluent) {
    this(fluent, new Format());
  }
  
  public FormatBuilder(FormatFluent<?> fluent,Format instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FormatBuilder(Format instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FormatFluent<?> fluent;
  
  public Format build() {
    Format buildable = new Format();
    buildable.setKey(fluent.buildKey());
    buildable.setValue(fluent.buildValue());
    buildable.setHeader(fluent.buildHeader());
    return buildable;
  }
  

}