package io.debezium.operator.api.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DebeziumServerStatusBuilder extends DebeziumServerStatusFluent<DebeziumServerStatusBuilder> implements VisitableBuilder<DebeziumServerStatus,DebeziumServerStatusBuilder>{
  public DebeziumServerStatusBuilder() {
    this(new DebeziumServerStatus());
  }
  
  public DebeziumServerStatusBuilder(DebeziumServerStatusFluent<?> fluent) {
    this(fluent, new DebeziumServerStatus());
  }
  
  public DebeziumServerStatusBuilder(DebeziumServerStatusFluent<?> fluent,DebeziumServerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DebeziumServerStatusBuilder(DebeziumServerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DebeziumServerStatusFluent<?> fluent;
  
  public DebeziumServerStatus build() {
    DebeziumServerStatus buildable = new DebeziumServerStatus();
    buildable.setConditions(fluent.getConditions());
    return buildable;
  }
  

}