package io.debezium.operator.api.model.source.storage.schema;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RedisSchemaHistoryStoreBuilder extends RedisSchemaHistoryStoreFluent<RedisSchemaHistoryStoreBuilder> implements VisitableBuilder<RedisSchemaHistoryStore,RedisSchemaHistoryStoreBuilder>{
  public RedisSchemaHistoryStoreBuilder() {
    this(new RedisSchemaHistoryStore());
  }
  
  public RedisSchemaHistoryStoreBuilder(RedisSchemaHistoryStoreFluent<?> fluent) {
    this(fluent, new RedisSchemaHistoryStore());
  }
  
  public RedisSchemaHistoryStoreBuilder(RedisSchemaHistoryStoreFluent<?> fluent,RedisSchemaHistoryStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RedisSchemaHistoryStoreBuilder(RedisSchemaHistoryStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RedisSchemaHistoryStoreFluent<?> fluent;
  
  public RedisSchemaHistoryStore build() {
    RedisSchemaHistoryStore buildable = new RedisSchemaHistoryStore();
    buildable.setAddress(fluent.getAddress());
    buildable.setUser(fluent.getUser());
    buildable.setPassword(fluent.getPassword());
    buildable.setSslEnabled(fluent.isSslEnabled());
    buildable.setKey(fluent.getKey());
    buildable.setWait(fluent.buildWait());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}