package io.debezium.operator.api.model.source.storage.schema;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class InMemorySchemaHistoryStoreBuilder extends InMemorySchemaHistoryStoreFluent<InMemorySchemaHistoryStoreBuilder> implements VisitableBuilder<InMemorySchemaHistoryStore,InMemorySchemaHistoryStoreBuilder>{
  public InMemorySchemaHistoryStoreBuilder() {
    this(new InMemorySchemaHistoryStore());
  }
  
  public InMemorySchemaHistoryStoreBuilder(InMemorySchemaHistoryStoreFluent<?> fluent) {
    this(fluent, new InMemorySchemaHistoryStore());
  }
  
  public InMemorySchemaHistoryStoreBuilder(InMemorySchemaHistoryStoreFluent<?> fluent,InMemorySchemaHistoryStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public InMemorySchemaHistoryStoreBuilder(InMemorySchemaHistoryStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  InMemorySchemaHistoryStoreFluent<?> fluent;
  
  public InMemorySchemaHistoryStore build() {
    InMemorySchemaHistoryStore buildable = new InMemorySchemaHistoryStore();
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}