package io.debezium.operator.api.model.source.storage.offset;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class InMemoryOffsetStoreBuilder extends InMemoryOffsetStoreFluent<InMemoryOffsetStoreBuilder> implements VisitableBuilder<InMemoryOffsetStore,InMemoryOffsetStoreBuilder>{
  public InMemoryOffsetStoreBuilder() {
    this(new InMemoryOffsetStore());
  }
  
  public InMemoryOffsetStoreBuilder(InMemoryOffsetStoreFluent<?> fluent) {
    this(fluent, new InMemoryOffsetStore());
  }
  
  public InMemoryOffsetStoreBuilder(InMemoryOffsetStoreFluent<?> fluent,InMemoryOffsetStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public InMemoryOffsetStoreBuilder(InMemoryOffsetStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  InMemoryOffsetStoreFluent<?> fluent;
  
  public InMemoryOffsetStore build() {
    InMemoryOffsetStore buildable = new InMemoryOffsetStore();
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}