package io.debezium.operator.api.model.runtime;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RuntimeBuilder extends RuntimeFluent<RuntimeBuilder> implements VisitableBuilder<Runtime,RuntimeBuilder>{
  public RuntimeBuilder() {
    this(new Runtime());
  }
  
  public RuntimeBuilder(RuntimeFluent<?> fluent) {
    this(fluent, new Runtime());
  }
  
  public RuntimeBuilder(RuntimeFluent<?> fluent,Runtime instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RuntimeBuilder(Runtime instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RuntimeFluent<?> fluent;
  
  public Runtime build() {
    Runtime buildable = new Runtime();
    buildable.setStorage(fluent.getStorage());
    buildable.setEnvironment(fluent.getEnvironment());
    buildable.setJmx(fluent.buildJmx());
    buildable.setTemplates(fluent.buildTemplates());
    buildable.setServiceAccount(fluent.getServiceAccount());
    buildable.setMetrics(fluent.buildMetrics());
    return buildable;
  }
  

}