package io.debezium.operator.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.debezium.operator.api.model.status.DebeziumServerStatusFluent;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.debezium.operator.api.model.status.DebeziumServerStatusBuilder;
import java.lang.Object;
import io.debezium.operator.api.model.status.DebeziumServerStatus;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DebeziumServerFluent<A extends DebeziumServerFluent<A>> extends CustomResourceFluent<DebeziumServerSpec,DebeziumServerStatus,A>{
  public DebeziumServerFluent() {
  }
  
  public DebeziumServerFluent(DebeziumServer instance) {
    this.copyInstance(instance);
  }
  private DebeziumServerSpecBuilder spec;
  private DebeziumServerStatusBuilder status;
  
  protected void copyInstance(DebeziumServer instance) {
    instance = (instance != null ? instance : new DebeziumServer());
    if (instance != null) {
          this.withMetadata(instance.getMetadata());
          this.withSpec(instance.getSpec());
          this.withStatus(instance.getStatus());
          this.withKind(instance.getKind());
          this.withApiVersion(instance.getApiVersion());
        }
  }
  
  public DebeziumServerSpec buildSpec() {
    return this.spec != null ? this.spec.build() : null;
  }
  
  public A withSpec(DebeziumServerSpec spec) {
    this._visitables.remove("spec");
    if (spec != null) {
        this.spec = new DebeziumServerSpecBuilder(spec);
        this._visitables.get("spec").add(this.spec);
    } else {
        this.spec = null;
        this._visitables.get("spec").remove(this.spec);
    }
    return (A) this;
  }
  
  public boolean hasSpec() {
    return this.spec != null;
  }
  
  public SpecNested<A> withNewSpec() {
    return new SpecNested(null);
  }
  
  public SpecNested<A> withNewSpecLike(DebeziumServerSpec item) {
    return new SpecNested(item);
  }
  
  public SpecNested<A> editSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(null));
  }
  
  public SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(new DebeziumServerSpecBuilder().build()));
  }
  
  public SpecNested<A> editOrNewSpecLike(DebeziumServerSpec item) {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(item));
  }
  
  public DebeziumServerStatus buildStatus() {
    return this.status != null ? this.status.build() : null;
  }
  
  public A withStatus(DebeziumServerStatus status) {
    this._visitables.remove("status");
    if (status != null) {
        this.status = new DebeziumServerStatusBuilder(status);
        this._visitables.get("status").add(this.status);
    } else {
        this.status = null;
        this._visitables.get("status").remove(this.status);
    }
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public StatusNested<A> withNewStatus() {
    return new StatusNested(null);
  }
  
  public StatusNested<A> withNewStatusLike(DebeziumServerStatus item) {
    return new StatusNested(item);
  }
  
  public StatusNested<A> editStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(null));
  }
  
  public StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(new DebeziumServerStatusBuilder().build()));
  }
  
  public StatusNested<A> editOrNewStatusLike(DebeziumServerStatus item) {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DebeziumServerFluent that = (DebeziumServerFluent) o;
    if (!java.util.Objects.equals(spec, that.spec)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(spec,  status,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  public class SpecNested<N> extends DebeziumServerSpecFluent<SpecNested<N>> implements Nested<N>{
    SpecNested(DebeziumServerSpec item) {
      this.builder = new DebeziumServerSpecBuilder(this, item);
    }
    DebeziumServerSpecBuilder builder;
    
    public N and() {
      return (N) DebeziumServerFluent.this.withSpec(builder.build());
    }
    
    public N endSpec() {
      return and();
    }
    
  
  }
  public class StatusNested<N> extends DebeziumServerStatusFluent<StatusNested<N>> implements Nested<N>{
    StatusNested(DebeziumServerStatus item) {
      this.builder = new DebeziumServerStatusBuilder(this, item);
    }
    DebeziumServerStatusBuilder builder;
    
    public N and() {
      return (N) DebeziumServerFluent.this.withStatus(builder.build());
    }
    
    public N endStatus() {
      return and();
    }
    
  
  }

}