package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SinkBuilder extends SinkFluent<SinkBuilder> implements VisitableBuilder<Sink,SinkBuilder>{
  public SinkBuilder() {
    this(new Sink());
  }
  
  public SinkBuilder(SinkFluent<?> fluent) {
    this(fluent, new Sink());
  }
  
  public SinkBuilder(SinkFluent<?> fluent,Sink instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SinkBuilder(Sink instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SinkFluent<?> fluent;
  
  public Sink build() {
    Sink buildable = new Sink();
    buildable.setType(fluent.getType());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}