package io.debezium.operator.api.model.runtime.jmx;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JmxConfigFluent<A extends JmxConfigFluent<A>> extends BaseFluent<A>{
  public JmxConfigFluent() {
  }
  
  public JmxConfigFluent(JmxConfig instance) {
    this.copyInstance(instance);
  }
  private boolean enabled;
  private int port;
  private JmxAuthenticationBuilder authentication;
  
  protected void copyInstance(JmxConfig instance) {
    instance = (instance != null ? instance : new JmxConfig());
    if (instance != null) {
          this.withEnabled(instance.isEnabled());
          this.withPort(instance.getPort());
          this.withAuthentication(instance.getAuthentication());
        }
  }
  
  public boolean isEnabled() {
    return this.enabled;
  }
  
  public A withEnabled(boolean enabled) {
    this.enabled = enabled;
    return (A) this;
  }
  
  public boolean hasEnabled() {
    return true;
  }
  
  public int getPort() {
    return this.port;
  }
  
  public A withPort(int port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return true;
  }
  
  public JmxAuthentication buildAuthentication() {
    return this.authentication != null ? this.authentication.build() : null;
  }
  
  public A withAuthentication(JmxAuthentication authentication) {
    this._visitables.remove("authentication");
    if (authentication != null) {
        this.authentication = new JmxAuthenticationBuilder(authentication);
        this._visitables.get("authentication").add(this.authentication);
    } else {
        this.authentication = null;
        this._visitables.get("authentication").remove(this.authentication);
    }
    return (A) this;
  }
  
  public boolean hasAuthentication() {
    return this.authentication != null;
  }
  
  public AuthenticationNested<A> withNewAuthentication() {
    return new AuthenticationNested(null);
  }
  
  public AuthenticationNested<A> withNewAuthenticationLike(JmxAuthentication item) {
    return new AuthenticationNested(item);
  }
  
  public AuthenticationNested<A> editAuthentication() {
    return withNewAuthenticationLike(java.util.Optional.ofNullable(buildAuthentication()).orElse(null));
  }
  
  public AuthenticationNested<A> editOrNewAuthentication() {
    return withNewAuthenticationLike(java.util.Optional.ofNullable(buildAuthentication()).orElse(new JmxAuthenticationBuilder().build()));
  }
  
  public AuthenticationNested<A> editOrNewAuthenticationLike(JmxAuthentication item) {
    return withNewAuthenticationLike(java.util.Optional.ofNullable(buildAuthentication()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JmxConfigFluent that = (JmxConfigFluent) o;
    if (enabled != that.enabled) return false;
    if (port != that.port) return false;
    if (!java.util.Objects.equals(authentication, that.authentication)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(enabled,  port,  authentication,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("enabled:"); sb.append(enabled + ",");
    sb.append("port:"); sb.append(port + ",");
    if (authentication != null) { sb.append("authentication:"); sb.append(authentication); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnabled() {
    return withEnabled(true);
  }
  public class AuthenticationNested<N> extends JmxAuthenticationFluent<AuthenticationNested<N>> implements Nested<N>{
    AuthenticationNested(JmxAuthentication item) {
      this.builder = new JmxAuthenticationBuilder(this, item);
    }
    JmxAuthenticationBuilder builder;
    
    public N and() {
      return (N) JmxConfigFluent.this.withAuthentication(builder.build());
    }
    
    public N endAuthentication() {
      return and();
    }
    
  
  }

}