package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import io.debezium.operator.api.model.runtime.Runtime;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.debezium.operator.api.model.runtime.RuntimeFluent;
import java.util.Collection;
import java.lang.Object;
import io.debezium.operator.api.model.runtime.RuntimeBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DebeziumServerSpecFluent<A extends DebeziumServerSpecFluent<A>> extends BaseFluent<A>{
  public DebeziumServerSpecFluent() {
  }
  
  public DebeziumServerSpecFluent(DebeziumServerSpec instance) {
    this.copyInstance(instance);
  }
  private String image;
  private String version;
  private SinkBuilder sink;
  private SourceBuilder source;
  private FormatBuilder format;
  private QuarkusBuilder quarkus;
  private RuntimeBuilder runtime;
  private ArrayList<TransformationBuilder> transforms = new ArrayList<TransformationBuilder>();
  private Map<String,Predicate> predicates;
  
  protected void copyInstance(DebeziumServerSpec instance) {
    instance = (instance != null ? instance : new DebeziumServerSpec());
    if (instance != null) {
          this.withImage(instance.getImage());
          this.withVersion(instance.getVersion());
          this.withSink(instance.getSink());
          this.withSource(instance.getSource());
          this.withFormat(instance.getFormat());
          this.withQuarkus(instance.getQuarkus());
          this.withRuntime(instance.getRuntime());
          this.withTransforms(instance.getTransforms());
          this.withPredicates(instance.getPredicates());
        }
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public Sink buildSink() {
    return this.sink != null ? this.sink.build() : null;
  }
  
  public A withSink(Sink sink) {
    this._visitables.remove("sink");
    if (sink != null) {
        this.sink = new SinkBuilder(sink);
        this._visitables.get("sink").add(this.sink);
    } else {
        this.sink = null;
        this._visitables.get("sink").remove(this.sink);
    }
    return (A) this;
  }
  
  public boolean hasSink() {
    return this.sink != null;
  }
  
  public SinkNested<A> withNewSink() {
    return new SinkNested(null);
  }
  
  public SinkNested<A> withNewSinkLike(Sink item) {
    return new SinkNested(item);
  }
  
  public SinkNested<A> editSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(null));
  }
  
  public SinkNested<A> editOrNewSink() {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(new SinkBuilder().build()));
  }
  
  public SinkNested<A> editOrNewSinkLike(Sink item) {
    return withNewSinkLike(java.util.Optional.ofNullable(buildSink()).orElse(item));
  }
  
  public Source buildSource() {
    return this.source != null ? this.source.build() : null;
  }
  
  public A withSource(Source source) {
    this._visitables.remove("source");
    if (source != null) {
        this.source = new SourceBuilder(source);
        this._visitables.get("source").add(this.source);
    } else {
        this.source = null;
        this._visitables.get("source").remove(this.source);
    }
    return (A) this;
  }
  
  public boolean hasSource() {
    return this.source != null;
  }
  
  public SourceNested<A> withNewSource() {
    return new SourceNested(null);
  }
  
  public SourceNested<A> withNewSourceLike(Source item) {
    return new SourceNested(item);
  }
  
  public SourceNested<A> editSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(null));
  }
  
  public SourceNested<A> editOrNewSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(new SourceBuilder().build()));
  }
  
  public SourceNested<A> editOrNewSourceLike(Source item) {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(item));
  }
  
  public Format buildFormat() {
    return this.format != null ? this.format.build() : null;
  }
  
  public A withFormat(Format format) {
    this._visitables.remove("format");
    if (format != null) {
        this.format = new FormatBuilder(format);
        this._visitables.get("format").add(this.format);
    } else {
        this.format = null;
        this._visitables.get("format").remove(this.format);
    }
    return (A) this;
  }
  
  public boolean hasFormat() {
    return this.format != null;
  }
  
  public FormatNested<A> withNewFormat() {
    return new FormatNested(null);
  }
  
  public FormatNested<A> withNewFormatLike(Format item) {
    return new FormatNested(item);
  }
  
  public FormatNested<A> editFormat() {
    return withNewFormatLike(java.util.Optional.ofNullable(buildFormat()).orElse(null));
  }
  
  public FormatNested<A> editOrNewFormat() {
    return withNewFormatLike(java.util.Optional.ofNullable(buildFormat()).orElse(new FormatBuilder().build()));
  }
  
  public FormatNested<A> editOrNewFormatLike(Format item) {
    return withNewFormatLike(java.util.Optional.ofNullable(buildFormat()).orElse(item));
  }
  
  public Quarkus buildQuarkus() {
    return this.quarkus != null ? this.quarkus.build() : null;
  }
  
  public A withQuarkus(Quarkus quarkus) {
    this._visitables.remove("quarkus");
    if (quarkus != null) {
        this.quarkus = new QuarkusBuilder(quarkus);
        this._visitables.get("quarkus").add(this.quarkus);
    } else {
        this.quarkus = null;
        this._visitables.get("quarkus").remove(this.quarkus);
    }
    return (A) this;
  }
  
  public boolean hasQuarkus() {
    return this.quarkus != null;
  }
  
  public QuarkusNested<A> withNewQuarkus() {
    return new QuarkusNested(null);
  }
  
  public QuarkusNested<A> withNewQuarkusLike(Quarkus item) {
    return new QuarkusNested(item);
  }
  
  public QuarkusNested<A> editQuarkus() {
    return withNewQuarkusLike(java.util.Optional.ofNullable(buildQuarkus()).orElse(null));
  }
  
  public QuarkusNested<A> editOrNewQuarkus() {
    return withNewQuarkusLike(java.util.Optional.ofNullable(buildQuarkus()).orElse(new QuarkusBuilder().build()));
  }
  
  public QuarkusNested<A> editOrNewQuarkusLike(Quarkus item) {
    return withNewQuarkusLike(java.util.Optional.ofNullable(buildQuarkus()).orElse(item));
  }
  
  public Runtime buildRuntime() {
    return this.runtime != null ? this.runtime.build() : null;
  }
  
  public A withRuntime(Runtime runtime) {
    this._visitables.remove("runtime");
    if (runtime != null) {
        this.runtime = new RuntimeBuilder(runtime);
        this._visitables.get("runtime").add(this.runtime);
    } else {
        this.runtime = null;
        this._visitables.get("runtime").remove(this.runtime);
    }
    return (A) this;
  }
  
  public boolean hasRuntime() {
    return this.runtime != null;
  }
  
  public RuntimeNested<A> withNewRuntime() {
    return new RuntimeNested(null);
  }
  
  public RuntimeNested<A> withNewRuntimeLike(Runtime item) {
    return new RuntimeNested(item);
  }
  
  public RuntimeNested<A> editRuntime() {
    return withNewRuntimeLike(java.util.Optional.ofNullable(buildRuntime()).orElse(null));
  }
  
  public RuntimeNested<A> editOrNewRuntime() {
    return withNewRuntimeLike(java.util.Optional.ofNullable(buildRuntime()).orElse(new RuntimeBuilder().build()));
  }
  
  public RuntimeNested<A> editOrNewRuntimeLike(Runtime item) {
    return withNewRuntimeLike(java.util.Optional.ofNullable(buildRuntime()).orElse(item));
  }
  
  public A addToTransforms(int index,Transformation item) {
    if (this.transforms == null) {this.transforms = new ArrayList<TransformationBuilder>();}
    TransformationBuilder builder = new TransformationBuilder(item);
    if (index < 0 || index >= transforms.size()) { _visitables.get("transforms").add(builder); transforms.add(builder); } else { _visitables.get("transforms").add(index, builder); transforms.add(index, builder);}
    return (A)this;
  }
  
  public A setToTransforms(int index,Transformation item) {
    if (this.transforms == null) {this.transforms = new ArrayList<TransformationBuilder>();}
    TransformationBuilder builder = new TransformationBuilder(item);
    if (index < 0 || index >= transforms.size()) { _visitables.get("transforms").add(builder); transforms.add(builder); } else { _visitables.get("transforms").set(index, builder); transforms.set(index, builder);}
    return (A)this;
  }
  
  public A addToTransforms(io.debezium.operator.api.model.Transformation... items) {
    if (this.transforms == null) {this.transforms = new ArrayList<TransformationBuilder>();}
    for (Transformation item : items) {TransformationBuilder builder = new TransformationBuilder(item);_visitables.get("transforms").add(builder);this.transforms.add(builder);} return (A)this;
  }
  
  public A addAllToTransforms(Collection<Transformation> items) {
    if (this.transforms == null) {this.transforms = new ArrayList<TransformationBuilder>();}
    for (Transformation item : items) {TransformationBuilder builder = new TransformationBuilder(item);_visitables.get("transforms").add(builder);this.transforms.add(builder);} return (A)this;
  }
  
  public A removeFromTransforms(io.debezium.operator.api.model.Transformation... items) {
    if (this.transforms == null) return (A)this;
    for (Transformation item : items) {TransformationBuilder builder = new TransformationBuilder(item);_visitables.get("transforms").remove(builder); this.transforms.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTransforms(Collection<Transformation> items) {
    if (this.transforms == null) return (A)this;
    for (Transformation item : items) {TransformationBuilder builder = new TransformationBuilder(item);_visitables.get("transforms").remove(builder); this.transforms.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTransforms(java.util.function.Predicate<TransformationBuilder> predicate) {
    if (transforms == null) return (A) this;
    final Iterator<TransformationBuilder> each = transforms.iterator();
    final List visitables = _visitables.get("transforms");
    while (each.hasNext()) {
      TransformationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Transformation> buildTransforms() {
    return this.transforms != null ? build(transforms) : null;
  }
  
  public Transformation buildTransform(int index) {
    return this.transforms.get(index).build();
  }
  
  public Transformation buildFirstTransform() {
    return this.transforms.get(0).build();
  }
  
  public Transformation buildLastTransform() {
    return this.transforms.get(transforms.size() - 1).build();
  }
  
  public Transformation buildMatchingTransform(java.util.function.Predicate<TransformationBuilder> predicate) {
      for (TransformationBuilder item : transforms) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTransform(java.util.function.Predicate<TransformationBuilder> predicate) {
      for (TransformationBuilder item : transforms) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTransforms(List<Transformation> transforms) {
    if (this.transforms != null) {
      this._visitables.get("transforms").clear();
    }
    if (transforms != null) {
        this.transforms = new ArrayList();
        for (Transformation item : transforms) {
          this.addToTransforms(item);
        }
    } else {
      this.transforms = null;
    }
    return (A) this;
  }
  
  public A withTransforms(io.debezium.operator.api.model.Transformation... transforms) {
    if (this.transforms != null) {
        this.transforms.clear();
        _visitables.remove("transforms");
    }
    if (transforms != null) {
      for (Transformation item : transforms) {
        this.addToTransforms(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTransforms() {
    return this.transforms != null && !this.transforms.isEmpty();
  }
  
  public TransformsNested<A> addNewTransform() {
    return new TransformsNested(-1, null);
  }
  
  public TransformsNested<A> addNewTransformLike(Transformation item) {
    return new TransformsNested(-1, item);
  }
  
  public TransformsNested<A> setNewTransformLike(int index,Transformation item) {
    return new TransformsNested(index, item);
  }
  
  public TransformsNested<A> editTransform(int index) {
    if (transforms.size() <= index) throw new RuntimeException("Can't edit transforms. Index exceeds size.");
    return setNewTransformLike(index, buildTransform(index));
  }
  
  public TransformsNested<A> editFirstTransform() {
    if (transforms.size() == 0) throw new RuntimeException("Can't edit first transforms. The list is empty.");
    return setNewTransformLike(0, buildTransform(0));
  }
  
  public TransformsNested<A> editLastTransform() {
    int index = transforms.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last transforms. The list is empty.");
    return setNewTransformLike(index, buildTransform(index));
  }
  
  public TransformsNested<A> editMatchingTransform(java.util.function.Predicate<TransformationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<transforms.size();i++) { 
    if (predicate.test(transforms.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching transforms. No match found.");
    return setNewTransformLike(index, buildTransform(index));
  }
  
  public A addToPredicates(String key,Predicate value) {
    if(this.predicates == null && key != null && value != null) { this.predicates = new LinkedHashMap(); }
    if(key != null && value != null) {this.predicates.put(key, value);} return (A)this;
  }
  
  public A addToPredicates(Map<String,Predicate> map) {
    if(this.predicates == null && map != null) { this.predicates = new LinkedHashMap(); }
    if(map != null) { this.predicates.putAll(map);} return (A)this;
  }
  
  public A removeFromPredicates(String key) {
    if(this.predicates == null) { return (A) this; }
    if(key != null && this.predicates != null) {this.predicates.remove(key);} return (A)this;
  }
  
  public A removeFromPredicates(Map<String,Predicate> map) {
    if(this.predicates == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.predicates != null){this.predicates.remove(key);}}} return (A)this;
  }
  
  public Map<String,Predicate> getPredicates() {
    return this.predicates;
  }
  
  public <K,V>A withPredicates(Map<String,Predicate> predicates) {
    if (predicates == null) {
      this.predicates = null;
    } else {
      this.predicates = new LinkedHashMap(predicates);
    }
    return (A) this;
  }
  
  public boolean hasPredicates() {
    return this.predicates != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DebeziumServerSpecFluent that = (DebeziumServerSpecFluent) o;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(sink, that.sink)) return false;
    if (!java.util.Objects.equals(source, that.source)) return false;
    if (!java.util.Objects.equals(format, that.format)) return false;
    if (!java.util.Objects.equals(quarkus, that.quarkus)) return false;
    if (!java.util.Objects.equals(runtime, that.runtime)) return false;
    if (!java.util.Objects.equals(transforms, that.transforms)) return false;
    if (!java.util.Objects.equals(predicates, that.predicates)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(image,  version,  sink,  source,  format,  quarkus,  runtime,  transforms,  predicates,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (format != null) { sb.append("format:"); sb.append(format + ","); }
    if (quarkus != null) { sb.append("quarkus:"); sb.append(quarkus + ","); }
    if (runtime != null) { sb.append("runtime:"); sb.append(runtime + ","); }
    if (transforms != null && !transforms.isEmpty()) { sb.append("transforms:"); sb.append(transforms + ","); }
    if (predicates != null && !predicates.isEmpty()) { sb.append("predicates:"); sb.append(predicates); }
    sb.append("}");
    return sb.toString();
  }
  public class SinkNested<N> extends SinkFluent<SinkNested<N>> implements Nested<N>{
    SinkNested(Sink item) {
      this.builder = new SinkBuilder(this, item);
    }
    SinkBuilder builder;
    
    public N and() {
      return (N) DebeziumServerSpecFluent.this.withSink(builder.build());
    }
    
    public N endSink() {
      return and();
    }
    
  
  }
  public class SourceNested<N> extends SourceFluent<SourceNested<N>> implements Nested<N>{
    SourceNested(Source item) {
      this.builder = new SourceBuilder(this, item);
    }
    SourceBuilder builder;
    
    public N and() {
      return (N) DebeziumServerSpecFluent.this.withSource(builder.build());
    }
    
    public N endSource() {
      return and();
    }
    
  
  }
  public class FormatNested<N> extends FormatFluent<FormatNested<N>> implements Nested<N>{
    FormatNested(Format item) {
      this.builder = new FormatBuilder(this, item);
    }
    FormatBuilder builder;
    
    public N and() {
      return (N) DebeziumServerSpecFluent.this.withFormat(builder.build());
    }
    
    public N endFormat() {
      return and();
    }
    
  
  }
  public class QuarkusNested<N> extends QuarkusFluent<QuarkusNested<N>> implements Nested<N>{
    QuarkusNested(Quarkus item) {
      this.builder = new QuarkusBuilder(this, item);
    }
    QuarkusBuilder builder;
    
    public N and() {
      return (N) DebeziumServerSpecFluent.this.withQuarkus(builder.build());
    }
    
    public N endQuarkus() {
      return and();
    }
    
  
  }
  public class RuntimeNested<N> extends RuntimeFluent<RuntimeNested<N>> implements Nested<N>{
    RuntimeNested(Runtime item) {
      this.builder = new RuntimeBuilder(this, item);
    }
    RuntimeBuilder builder;
    
    public N and() {
      return (N) DebeziumServerSpecFluent.this.withRuntime(builder.build());
    }
    
    public N endRuntime() {
      return and();
    }
    
  
  }
  public class TransformsNested<N> extends TransformationFluent<TransformsNested<N>> implements Nested<N>{
    TransformsNested(int index,Transformation item) {
      this.index = index;
      this.builder = new TransformationBuilder(this, item);
    }
    TransformationBuilder builder;
    int index;
    
    public N and() {
      return (N) DebeziumServerSpecFluent.this.setToTransforms(index,builder.build());
    }
    
    public N endTransform() {
      return and();
    }
    
  
  }

}