package io.debezium.operator.api.model.runtime.templates;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TemplatesBuilder extends TemplatesFluent<TemplatesBuilder> implements VisitableBuilder<Templates,TemplatesBuilder>{
  public TemplatesBuilder() {
    this(new Templates());
  }
  
  public TemplatesBuilder(TemplatesFluent<?> fluent) {
    this(fluent, new Templates());
  }
  
  public TemplatesBuilder(TemplatesFluent<?> fluent,Templates instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TemplatesBuilder(Templates instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TemplatesFluent<?> fluent;
  
  public Templates build() {
    Templates buildable = new Templates();
    buildable.setContainer(fluent.getContainer());
    buildable.setPod(fluent.getPod());
    buildable.setVolumeClaim(fluent.getVolumeClaim());
    return buildable;
  }
  

}