package io.debezium.operator.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TransformationFluent<A extends TransformationFluent<A>> extends BaseFluent<A>{
  public TransformationFluent() {
  }
  
  public TransformationFluent(Transformation instance) {
    this.copyInstance(instance);
  }
  private String type;
  private String predicate;
  private boolean negate;
  private ConfigProperties config;
  
  protected void copyInstance(Transformation instance) {
    instance = (instance != null ? instance : new Transformation());
    if (instance != null) {
          this.withType(instance.getType());
          this.withPredicate(instance.getPredicate());
          this.withNegate(instance.isNegate());
          this.withConfig(instance.getConfig());
        }
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public String getPredicate() {
    return this.predicate;
  }
  
  public A withPredicate(String predicate) {
    this.predicate = predicate;
    return (A) this;
  }
  
  public boolean hasPredicate() {
    return this.predicate != null;
  }
  
  public boolean isNegate() {
    return this.negate;
  }
  
  public A withNegate(boolean negate) {
    this.negate = negate;
    return (A) this;
  }
  
  public boolean hasNegate() {
    return true;
  }
  
  public ConfigProperties getConfig() {
    return this.config;
  }
  
  public A withConfig(ConfigProperties config) {
    this.config = config;
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TransformationFluent that = (TransformationFluent) o;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(predicate, that.predicate)) return false;
    if (negate != that.negate) return false;
    if (!java.util.Objects.equals(config, that.config)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(type,  predicate,  negate,  config,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (predicate != null) { sb.append("predicate:"); sb.append(predicate + ","); }
    sb.append("negate:"); sb.append(negate + ",");
    if (config != null) { sb.append("config:"); sb.append(config); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withNegate() {
    return withNegate(true);
  }
  

}