package io.debezium.operator.api.model.runtime.templates;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TemplatesFluent<A extends TemplatesFluent<A>> extends BaseFluent<A>{
  public TemplatesFluent() {
  }
  
  public TemplatesFluent(Templates instance) {
    this.copyInstance(instance);
  }
  private ContainerTemplate container;
  private PodTemplate pod;
  private PersistentVolumeClaimSpec volumeClaim;
  
  protected void copyInstance(Templates instance) {
    instance = (instance != null ? instance : new Templates());
    if (instance != null) {
          this.withContainer(instance.getContainer());
          this.withPod(instance.getPod());
          this.withVolumeClaim(instance.getVolumeClaim());
        }
  }
  
  public ContainerTemplate getContainer() {
    return this.container;
  }
  
  public A withContainer(ContainerTemplate container) {
    this.container = container;
    return (A) this;
  }
  
  public boolean hasContainer() {
    return this.container != null;
  }
  
  public PodTemplate getPod() {
    return this.pod;
  }
  
  public A withPod(PodTemplate pod) {
    this.pod = pod;
    return (A) this;
  }
  
  public boolean hasPod() {
    return this.pod != null;
  }
  
  public PersistentVolumeClaimSpec getVolumeClaim() {
    return this.volumeClaim;
  }
  
  public A withVolumeClaim(PersistentVolumeClaimSpec volumeClaim) {
    this.volumeClaim = volumeClaim;
    return (A) this;
  }
  
  public boolean hasVolumeClaim() {
    return this.volumeClaim != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TemplatesFluent that = (TemplatesFluent) o;
    if (!java.util.Objects.equals(container, that.container)) return false;
    if (!java.util.Objects.equals(pod, that.pod)) return false;
    if (!java.util.Objects.equals(volumeClaim, that.volumeClaim)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(container,  pod,  volumeClaim,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (volumeClaim != null) { sb.append("volumeClaim:"); sb.append(volumeClaim); }
    sb.append("}");
    return sb.toString();
  }
  

}