package io.debezium.operator.api.model.runtime.jmx;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JmxConfigBuilder extends JmxConfigFluent<JmxConfigBuilder> implements VisitableBuilder<JmxConfig,JmxConfigBuilder>{
  public JmxConfigBuilder() {
    this(new JmxConfig());
  }
  
  public JmxConfigBuilder(JmxConfigFluent<?> fluent) {
    this(fluent, new JmxConfig());
  }
  
  public JmxConfigBuilder(JmxConfigFluent<?> fluent,JmxConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JmxConfigBuilder(JmxConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JmxConfigFluent<?> fluent;
  
  public JmxConfig build() {
    JmxConfig buildable = new JmxConfig();
    buildable.setEnabled(fluent.isEnabled());
    buildable.setPort(fluent.getPort());
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  

}