package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TransformationBuilder extends TransformationFluent<TransformationBuilder> implements VisitableBuilder<Transformation,TransformationBuilder>{
  public TransformationBuilder() {
    this(new Transformation());
  }
  
  public TransformationBuilder(TransformationFluent<?> fluent) {
    this(fluent, new Transformation());
  }
  
  public TransformationBuilder(TransformationFluent<?> fluent,Transformation instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TransformationBuilder(Transformation instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TransformationFluent<?> fluent;
  
  public Transformation build() {
    Transformation buildable = new Transformation();
    buildable.setType(fluent.getType());
    buildable.setPredicate(fluent.getPredicate());
    buildable.setNegate(fluent.isNegate());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}