package io.debezium.operator.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SourceFluent<A extends SourceFluent<A>> extends BaseFluent<A>{
  public SourceFluent() {
  }
  
  public SourceFluent(Source instance) {
    this.copyInstance(instance);
  }
  private String sourceClass;
  private ConfigProperties config;
  
  protected void copyInstance(Source instance) {
    instance = (instance != null ? instance : new Source());
    if (instance != null) {
          this.withSourceClass(instance.getSourceClass());
          this.withConfig(instance.getConfig());
        }
  }
  
  public String getSourceClass() {
    return this.sourceClass;
  }
  
  public A withSourceClass(String sourceClass) {
    this.sourceClass = sourceClass;
    return (A) this;
  }
  
  public boolean hasSourceClass() {
    return this.sourceClass != null;
  }
  
  public ConfigProperties getConfig() {
    return this.config;
  }
  
  public A withConfig(ConfigProperties config) {
    this.config = config;
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SourceFluent that = (SourceFluent) o;
    if (!java.util.Objects.equals(sourceClass, that.sourceClass)) return false;
    if (!java.util.Objects.equals(config, that.config)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(sourceClass,  config,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sourceClass != null) { sb.append("sourceClass:"); sb.append(sourceClass + ","); }
    if (config != null) { sb.append("config:"); sb.append(config); }
    sb.append("}");
    return sb.toString();
  }
  

}