package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QuarkusBuilder extends QuarkusFluent<QuarkusBuilder> implements VisitableBuilder<Quarkus,QuarkusBuilder>{
  public QuarkusBuilder() {
    this(new Quarkus());
  }
  
  public QuarkusBuilder(QuarkusFluent<?> fluent) {
    this(fluent, new Quarkus());
  }
  
  public QuarkusBuilder(QuarkusFluent<?> fluent,Quarkus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QuarkusBuilder(Quarkus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QuarkusFluent<?> fluent;
  
  public Quarkus build() {
    Quarkus buildable = new Quarkus();
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}