package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FormatTypeBuilder extends FormatTypeFluent<FormatTypeBuilder> implements VisitableBuilder<FormatType,FormatTypeBuilder>{
  public FormatTypeBuilder() {
    this(new FormatType());
  }
  
  public FormatTypeBuilder(FormatTypeFluent<?> fluent) {
    this(fluent, new FormatType());
  }
  
  public FormatTypeBuilder(FormatTypeFluent<?> fluent,FormatType instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FormatTypeBuilder(FormatType instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FormatTypeFluent<?> fluent;
  
  public FormatType build() {
    FormatType buildable = new FormatType();
    buildable.setType(fluent.getType());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}