package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DebeziumServerSpecBuilder extends DebeziumServerSpecFluent<DebeziumServerSpecBuilder> implements VisitableBuilder<DebeziumServerSpec,DebeziumServerSpecBuilder>{
  public DebeziumServerSpecBuilder() {
    this(new DebeziumServerSpec());
  }
  
  public DebeziumServerSpecBuilder(DebeziumServerSpecFluent<?> fluent) {
    this(fluent, new DebeziumServerSpec());
  }
  
  public DebeziumServerSpecBuilder(DebeziumServerSpecFluent<?> fluent,DebeziumServerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DebeziumServerSpecBuilder(DebeziumServerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DebeziumServerSpecFluent<?> fluent;
  
  public DebeziumServerSpec build() {
    DebeziumServerSpec buildable = new DebeziumServerSpec();
    buildable.setImage(fluent.getImage());
    buildable.setVersion(fluent.getVersion());
    buildable.setSink(fluent.buildSink());
    buildable.setSource(fluent.buildSource());
    buildable.setFormat(fluent.buildFormat());
    buildable.setQuarkus(fluent.buildQuarkus());
    buildable.setRuntime(fluent.buildRuntime());
    buildable.setTransforms(fluent.buildTransforms());
    buildable.setPredicates(fluent.getPredicates());
    return buildable;
  }
  

}