/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.config;

import io.debezium.operator.api.config.ConfigMapping;
import io.debezium.operator.api.model.ConfigProperties;
import io.debezium.operator.api.model.Predicate;
import io.debezium.operator.api.model.Transformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigMappingTest {
    @Test
    void shouldNotAddNullValue() {
        ConfigMapping config = ConfigMapping.empty();
        config.put("invalid", null);
        Assertions.assertThat((Map)config.getAsMap()).isEmpty();
        Assertions.assertThat((String)config.getAsString()).isEmpty();
    }

    @Test
    void shouldAddRootValue() {
        ConfigMapping config = ConfigMapping.empty();
        config.rootValue((Object)"json");
        Assertions.assertThat((Map)config.getAsMap()).containsEntry((Object)"", (Object)"json");
        Assertions.assertThat((String)config.getAsString()).isEqualTo("=json");
    }

    @Test
    void shouldAddKeyAndValue() {
        ConfigMapping config = ConfigMapping.empty();
        config.put("key", (Object)"value");
        Assertions.assertThat((Map)config.getAsMap()).containsEntry((Object)"key", (Object)"value");
        Assertions.assertThat((String)config.getAsString()).isEqualTo("key=value");
    }

    @Test
    void shouldAddValuesFromMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        properties.put("key2", "value2");
        ConfigMapping config = ConfigMapping.empty();
        config.putAll(properties);
        Assertions.assertThat((Map)config.getAsMap()).contains(new Map.Entry[]{Assertions.entry((Object)"key1", (Object)"value1"), Assertions.entry((Object)"key2", (Object)"value2")});
        Assertions.assertThat((String)config.getAsString()).isEqualTo("key1=value1\nkey2=value2");
    }

    @Test
    void shouldAddList() {
        ConfigMapping config = ConfigMapping.empty();
        List<Map<String, Boolean>> configDataList = List.of(Map.of("type", "io.debezium.transforms.ByLogicalTableRouter", "negate", false), Map.of("type", "io.debezium.transforms.ByLogicalTableRouter", "negate", true));
        ArrayList<Transformation> transformations = new ArrayList<Transformation>();
        for (Map<String, Boolean> configData : configDataList) {
            ConfigProperties configProperties = new ConfigProperties();
            Transformation transformation = new Transformation();
            transformation.setType((String)((Object)configData.get("type")));
            transformation.setNegate(configData.get("negate").booleanValue());
            transformation.setConfig(configProperties);
            transformations.add(transformation);
        }
        config.putList("transforms", transformations, "Reroute");
        Assertions.assertThat((Map)config.getAsMap()).containsEntry((Object)"transforms", (Object)"");
        Assertions.assertThat((Map)config.getAsMap()).containsEntry((Object)"transforms.Reroute0.type", (Object)"io.debezium.transforms.ByLogicalTableRouter");
        Assertions.assertThat((Map)config.getAsMap()).containsEntry((Object)"transforms.Reroute0.negate", (Object)"false");
        Assertions.assertThat((Map)config.getAsMap()).containsEntry((Object)"transforms.Reroute1.type", (Object)"io.debezium.transforms.ByLogicalTableRouter");
        Assertions.assertThat((Map)config.getAsMap()).containsEntry((Object)"transforms.Reroute1.negate", (Object)"true");
        Assertions.assertThat((String)config.getAsString()).isEqualTo("transforms.Reroute0.negate=false\ntransforms.Reroute0.type=io.debezium.transforms.ByLogicalTableRouter\ntransforms.Reroute1.negate=true\ntransforms.Reroute1.type=io.debezium.transforms.ByLogicalTableRouter\ntransforms=");
    }

    @Test
    void shouldAddMap() {
        ConfigMapping config = ConfigMapping.empty();
        ConfigProperties configProperties = new ConfigProperties();
        Predicate predicate = new Predicate();
        predicate.setType("IsOutboxTable");
        predicate.setConfig(configProperties);
        Map<String, Predicate> predicateMap = Map.of("predicates", predicate);
        config.putMap("map", predicateMap);
        Assertions.assertThat((Map)config.getAsMap()).containsEntry((Object)"map", (Object)"predicates");
        Assertions.assertThat((Map)config.getAsMap()).containsEntry((Object)"map.predicates.type", (Object)"IsOutboxTable");
        Assertions.assertThat((String)config.getAsString()).isEqualTo("map.predicates.type=IsOutboxTable\nmap=predicates");
    }

    @Test
    void shouldCalculateMD5Sum() {
        ConfigMapping config = ConfigMapping.empty();
        config.put("key1", (Object)"value1");
        String md5Sum = config.md5Sum();
        Assertions.assertThat((String)md5Sum).isEqualTo("9767c4972ba72e87ab553bad2afde741");
    }
}

