package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DebeziumServerSpecBuilder extends DebeziumServerSpecFluent<DebeziumServerSpecBuilder> implements VisitableBuilder<DebeziumServerSpec,DebeziumServerSpecBuilder>{
  public DebeziumServerSpecBuilder() {
    this(new DebeziumServerSpec());
  }
  
  public DebeziumServerSpecBuilder(DebeziumServerSpecFluent<?> fluent) {
    this(fluent, new DebeziumServerSpec());
  }
  
  public DebeziumServerSpecBuilder(DebeziumServerSpecFluent<?> fluent,DebeziumServerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DebeziumServerSpecBuilder(DebeziumServerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DebeziumServerSpecFluent<?> fluent;
  
  public DebeziumServerSpec build() {
    DebeziumServerSpec buildable = new DebeziumServerSpec();
    buildable.setImage(fluent.getImage());
    buildable.setVersion(fluent.getVersion());
    buildable.setStorage(fluent.getStorage());
    buildable.setSink(fluent.getSink());
    buildable.setSource(fluent.getSource());
    buildable.setFormat(fluent.getFormat());
    buildable.setQuarkus(fluent.getQuarkus());
    buildable.setRuntime(fluent.getRuntime());
    buildable.setTransforms(fluent.getTransforms());
    buildable.setPredicates(fluent.getPredicates());
    return buildable;
  }
  

}