package io.debezium.operator.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DebeziumServerSpecFluentImpl<A extends DebeziumServerSpecFluent<A>> extends BaseFluent<A> implements DebeziumServerSpecFluent<A>{
  public DebeziumServerSpecFluentImpl() {
  }
  public DebeziumServerSpecFluentImpl(DebeziumServerSpec instance) {
    if (instance != null) {
      this.withImage(instance.getImage());
      this.withVersion(instance.getVersion());
      this.withStorage(instance.getStorage());
      this.withSink(instance.getSink());
      this.withSource(instance.getSource());
      this.withFormat(instance.getFormat());
      this.withQuarkus(instance.getQuarkus());
      this.withRuntime(instance.getRuntime());
      this.withTransforms(instance.getTransforms());
      this.withPredicates(instance.getPredicates());
    }
  }
  private String image;
  private String version;
  private Storage storage;
  private Sink sink;
  private Source source;
  private Format format;
  private Quarkus quarkus;
  private Runtime runtime;
  private List<Transformation> transforms = new ArrayList<Transformation>();
  private Map<String,Predicate> predicates;
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public Storage getStorage() {
    return this.storage;
  }
  public A withStorage(Storage storage) {
    this.storage=storage; return (A) this;
  }
  public Boolean hasStorage() {
    return this.storage != null;
  }
  public Sink getSink() {
    return this.sink;
  }
  public A withSink(Sink sink) {
    this.sink=sink; return (A) this;
  }
  public Boolean hasSink() {
    return this.sink != null;
  }
  public Source getSource() {
    return this.source;
  }
  public A withSource(Source source) {
    this.source=source; return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public Format getFormat() {
    return this.format;
  }
  public A withFormat(Format format) {
    this.format=format; return (A) this;
  }
  public Boolean hasFormat() {
    return this.format != null;
  }
  public Quarkus getQuarkus() {
    return this.quarkus;
  }
  public A withQuarkus(Quarkus quarkus) {
    this.quarkus=quarkus; return (A) this;
  }
  public Boolean hasQuarkus() {
    return this.quarkus != null;
  }
  public Runtime getRuntime() {
    return this.runtime;
  }
  public A withRuntime(Runtime runtime) {
    this.runtime=runtime; return (A) this;
  }
  public Boolean hasRuntime() {
    return this.runtime != null;
  }
  public A addToTransforms(int index,Transformation item) {
    if (this.transforms == null) {this.transforms = new ArrayList<Transformation>();}
    this.transforms.add(index, item);
    return (A)this;
  }
  public A setToTransforms(int index,Transformation item) {
    if (this.transforms == null) {this.transforms = new ArrayList<Transformation>();}
    this.transforms.set(index, item); return (A)this;
  }
  public A addToTransforms(io.debezium.operator.api.model.Transformation... items) {
    if (this.transforms == null) {this.transforms = new ArrayList<Transformation>();}
    for (Transformation item : items) {this.transforms.add(item);} return (A)this;
  }
  public A addAllToTransforms(Collection<Transformation> items) {
    if (this.transforms == null) {this.transforms = new ArrayList<Transformation>();}
    for (Transformation item : items) {this.transforms.add(item);} return (A)this;
  }
  public A removeFromTransforms(io.debezium.operator.api.model.Transformation... items) {
    for (Transformation item : items) {if (this.transforms!= null){ this.transforms.remove(item);}} return (A)this;
  }
  public A removeAllFromTransforms(Collection<Transformation> items) {
    for (Transformation item : items) {if (this.transforms!= null){ this.transforms.remove(item);}} return (A)this;
  }
  public List<Transformation> getTransforms() {
    return this.transforms;
  }
  public Transformation getTransform(int index) {
    return this.transforms.get(index);
  }
  public Transformation getFirstTransform() {
    return this.transforms.get(0);
  }
  public Transformation getLastTransform() {
    return this.transforms.get(transforms.size() - 1);
  }
  public Transformation getMatchingTransform(java.util.function.Predicate<Transformation> predicate) {
    for (Transformation item: transforms) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTransform(java.util.function.Predicate<Transformation> predicate) {
    for (Transformation item: transforms) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTransforms(List<Transformation> transforms) {
    if (transforms != null) {this.transforms = new ArrayList(); for (Transformation item : transforms){this.addToTransforms(item);}} else { this.transforms = null;} return (A) this;
  }
  public A withTransforms(io.debezium.operator.api.model.Transformation... transforms) {
    if (this.transforms != null) {this.transforms.clear(); _visitables.remove("transforms"); }
    if (transforms != null) {for (Transformation item :transforms){ this.addToTransforms(item);}} return (A) this;
  }
  public Boolean hasTransforms() {
    return transforms != null && !transforms.isEmpty();
  }
  public A addToPredicates(String key,Predicate value) {
    if(this.predicates == null && key != null && value != null) { this.predicates = new LinkedHashMap(); }
    if(key != null && value != null) {this.predicates.put(key, value);} return (A)this;
  }
  public A addToPredicates(Map<String,Predicate> map) {
    if(this.predicates == null && map != null) { this.predicates = new LinkedHashMap(); }
    if(map != null) { this.predicates.putAll(map);} return (A)this;
  }
  public A removeFromPredicates(String key) {
    if(this.predicates == null) { return (A) this; }
    if(key != null && this.predicates != null) {this.predicates.remove(key);} return (A)this;
  }
  public A removeFromPredicates(Map<String,Predicate> map) {
    if(this.predicates == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.predicates != null){this.predicates.remove(key);}}} return (A)this;
  }
  public Map<String,Predicate> getPredicates() {
    return this.predicates;
  }
  public <K,V>A withPredicates(Map<String,Predicate> predicates) {
    if (predicates == null) { this.predicates =  null;} else {this.predicates = new LinkedHashMap(predicates);} return (A) this;
  }
  public Boolean hasPredicates() {
    return this.predicates != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DebeziumServerSpecFluentImpl that = (DebeziumServerSpecFluentImpl) o;
    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(sink, that.sink)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(format, that.format)) return false;

    if (!java.util.Objects.equals(quarkus, that.quarkus)) return false;

    if (!java.util.Objects.equals(runtime, that.runtime)) return false;

    if (!java.util.Objects.equals(transforms, that.transforms)) return false;

    if (!java.util.Objects.equals(predicates, that.predicates)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(image,  version,  storage,  sink,  source,  format,  quarkus,  runtime,  transforms,  predicates,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (format != null) { sb.append("format:"); sb.append(format + ","); }
    if (quarkus != null) { sb.append("quarkus:"); sb.append(quarkus + ","); }
    if (runtime != null) { sb.append("runtime:"); sb.append(runtime + ","); }
    if (transforms != null && !transforms.isEmpty()) { sb.append("transforms:"); sb.append(transforms + ","); }
    if (predicates != null && !predicates.isEmpty()) { sb.append("predicates:"); sb.append(predicates); }
    sb.append("}");
    return sb.toString();
  }
  
}