package io.debezium.operator.api.model;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.debezium.operator.docs.annotations.Documented.Field;
import java.util.LinkedHashMap;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface DebeziumServerSpecFluent<A extends DebeziumServerSpecFluent<A>> extends Fluent<A>{
  public String getImage();
  public A withImage(String image);
  public Boolean hasImage();
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public Storage getStorage();
  public A withStorage(Storage storage);
  public Boolean hasStorage();
  public Sink getSink();
  public A withSink(Sink sink);
  public Boolean hasSink();
  public Source getSource();
  public A withSource(Source source);
  public Boolean hasSource();
  public Format getFormat();
  public A withFormat(Format format);
  public Boolean hasFormat();
  public Quarkus getQuarkus();
  public A withQuarkus(Quarkus quarkus);
  public Boolean hasQuarkus();
  public Runtime getRuntime();
  public A withRuntime(Runtime runtime);
  public Boolean hasRuntime();
  public A addToTransforms(int index,Transformation item);
  public A setToTransforms(int index,Transformation item);
  public A addToTransforms(io.debezium.operator.api.model.Transformation... items);
  public A addAllToTransforms(Collection<Transformation> items);
  public A removeFromTransforms(io.debezium.operator.api.model.Transformation... items);
  public A removeAllFromTransforms(Collection<Transformation> items);
  public List<Transformation> getTransforms();
  public Transformation getTransform(int index);
  public Transformation getFirstTransform();
  public Transformation getLastTransform();
  public Transformation getMatchingTransform(java.util.function.Predicate<Transformation> predicate);
  public Boolean hasMatchingTransform(java.util.function.Predicate<Transformation> predicate);
  public A withTransforms(List<Transformation> transforms);
  public A withTransforms(io.debezium.operator.api.model.Transformation... transforms);
  public Boolean hasTransforms();
  public A addToPredicates(String key,Predicate value);
  public A addToPredicates(Map<String,Predicate> map);
  public A removeFromPredicates(String key);
  public A removeFromPredicates(Map<String,Predicate> map);
  public Map<String,Predicate> getPredicates();
  public <K,V>A withPredicates(Map<String,Predicate> predicates);
  public Boolean hasPredicates();
  
}