package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DebeziumServerBuilder extends DebeziumServerFluentImpl<DebeziumServerBuilder> implements VisitableBuilder<DebeziumServer,DebeziumServerBuilder>{
  public DebeziumServerBuilder() {
    this(false);
  }
  public DebeziumServerBuilder(Boolean validationEnabled) {
    this(new DebeziumServer(), validationEnabled);
  }
  public DebeziumServerBuilder(DebeziumServerFluent<?> fluent) {
    this(fluent, false);
  }
  public DebeziumServerBuilder(DebeziumServerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DebeziumServer(), validationEnabled);
  }
  public DebeziumServerBuilder(DebeziumServerFluent<?> fluent,DebeziumServer instance) {
    this(fluent, instance, false);
  }
  public DebeziumServerBuilder(DebeziumServerFluent<?> fluent,DebeziumServer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withKind(instance.getKind());
      fluent.withApiVersion(instance.getApiVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DebeziumServerBuilder(DebeziumServer instance) {
    this(instance,false);
  }
  public DebeziumServerBuilder(DebeziumServer instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withKind(instance.getKind());
      this.withApiVersion(instance.getApiVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  DebeziumServerFluent<?> fluent;
  Boolean validationEnabled;
  public DebeziumServer build() {
    DebeziumServer buildable = new DebeziumServer();
    buildable.setMetadata(fluent.getMetadata());
    buildable.setSpec(fluent.getSpec());
    buildable.setStatus(fluent.getStatus());
    buildable.setKind(fluent.getKind());
    buildable.setApiVersion(fluent.getApiVersion());
    return buildable;
  }
  
}