package io.debezium.operator.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DebeziumServerSpecBuilder extends DebeziumServerSpecFluentImpl<DebeziumServerSpecBuilder> implements VisitableBuilder<DebeziumServerSpec,DebeziumServerSpecBuilder>{
  public DebeziumServerSpecBuilder() {
    this(false);
  }
  public DebeziumServerSpecBuilder(Boolean validationEnabled) {
    this(new DebeziumServerSpec(), validationEnabled);
  }
  public DebeziumServerSpecBuilder(DebeziumServerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DebeziumServerSpecBuilder(DebeziumServerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DebeziumServerSpec(), validationEnabled);
  }
  public DebeziumServerSpecBuilder(DebeziumServerSpecFluent<?> fluent,DebeziumServerSpec instance) {
    this(fluent, instance, false);
  }
  public DebeziumServerSpecBuilder(DebeziumServerSpecFluent<?> fluent,DebeziumServerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withImage(instance.getImage());
      fluent.withVersion(instance.getVersion());
      fluent.withStorage(instance.getStorage());
      fluent.withSink(instance.getSink());
      fluent.withSource(instance.getSource());
      fluent.withFormat(instance.getFormat());
      fluent.withQuarkus(instance.getQuarkus());
      fluent.withRuntime(instance.getRuntime());
      fluent.withTransforms(instance.getTransforms());
      fluent.withPredicates(instance.getPredicates());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DebeziumServerSpecBuilder(DebeziumServerSpec instance) {
    this(instance,false);
  }
  public DebeziumServerSpecBuilder(DebeziumServerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withImage(instance.getImage());
      this.withVersion(instance.getVersion());
      this.withStorage(instance.getStorage());
      this.withSink(instance.getSink());
      this.withSource(instance.getSource());
      this.withFormat(instance.getFormat());
      this.withQuarkus(instance.getQuarkus());
      this.withRuntime(instance.getRuntime());
      this.withTransforms(instance.getTransforms());
      this.withPredicates(instance.getPredicates());
    }
    this.validationEnabled = validationEnabled; 
  }
  DebeziumServerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DebeziumServerSpec build() {
    DebeziumServerSpec buildable = new DebeziumServerSpec();
    buildable.setImage(fluent.getImage());
    buildable.setVersion(fluent.getVersion());
    buildable.setStorage(fluent.getStorage());
    buildable.setSink(fluent.getSink());
    buildable.setSource(fluent.getSource());
    buildable.setFormat(fluent.getFormat());
    buildable.setQuarkus(fluent.getQuarkus());
    buildable.setRuntime(fluent.getRuntime());
    buildable.setTransforms(fluent.getTransforms());
    buildable.setPredicates(fluent.getPredicates());
    return buildable;
  }
  
}