/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.performance.connector.mysql.parser;

import io.debezium.connector.mysql.MySqlDdlParser;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

public class MySqlDdlParserPerf {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Fork(value=1)
    @Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=2, timeUnit=TimeUnit.SECONDS)
    public void legacy(ParserState state) {
        state.legacyParser.parse(state.ddl, state.tables);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Fork(value=1)
    @Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=2, timeUnit=TimeUnit.SECONDS)
    public void antlr(ParserState state) {
        state.antlrParser.parse(state.ddl, state.tables);
    }

    @State(value=Scope.Thread)
    public static class ParserState {
        public AbstractDdlParser legacyParser;
        public AbstractDdlParser antlrParser;
        public Tables tables;
        public String ddl;
        @Param(value={"1", "2", "5", "10", "20", "50"})
        public int columnCount;

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.legacyParser = new MySqlDdlParser();
            this.antlrParser = new MySqlAntlrDdlParser();
            this.tables = new Tables();
            this.ddl = this.testStatement();
        }

        private String testStatement() {
            StringBuilder sb = new StringBuilder("CREATE TABLE t1 (id int primary key");
            for (int i = 0; i < this.columnCount; ++i) {
                sb.append(", v").append(i).append(" int");
            }
            String statement = sb.append(")").toString();
            return statement;
        }
    }
}

