/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.embedded.EmbeddedEngineConfig;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Predicates
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Predicates.class);
    private static final String TYPE_SUFFIX = ".type";
    private final Map<String, Predicate<SourceRecord>> predicates = new HashMap<String, Predicate<SourceRecord>>();

    public Predicates(Configuration config) {
        String predicateList = config.getString(EmbeddedEngineConfig.PREDICATES);
        if (predicateList == null) {
            return;
        }
        for (String predicateName : predicateList.split(",")) {
            predicateName = predicateName.trim();
            Predicate<SourceRecord> predicate = Predicates.createPredicate(config, predicateName);
            this.predicates.put(predicateName, predicate);
        }
    }

    public Predicate<SourceRecord> getPredicate(String name) {
        return this.predicates.get(name);
    }

    private static Predicate<SourceRecord> createPredicate(Configuration config, String name) {
        Predicate predicate;
        String predicatePrefix = Predicates.predicateConfigNamespace(name);
        try {
            predicate = (Predicate)config.getInstance(predicatePrefix + TYPE_SUFFIX, Predicate.class);
        }
        catch (Exception e) {
            throw new DebeziumException("Error while instantiating predicate '" + name + "'", (Throwable)e);
        }
        if (predicate == null) {
            throw new DebeziumException("Cannot instantiate predicate '" + name + "'");
        }
        predicate.configure(config.subset(predicatePrefix, true).asMap());
        return predicate;
    }

    private static String predicateConfigNamespace(String name) {
        return EmbeddedEngineConfig.PREDICATES.name() + "." + name;
    }

    @Override
    public void close() throws IOException {
        for (Predicate<SourceRecord> p : this.predicates.values()) {
            try {
                p.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error while closing predicate", (Throwable)e);
            }
        }
    }
}

