/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.embedded.async.RetryingCallable;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.util.DelayStrategy;
import io.debezium.util.LoggingContext;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kafka.connect.errors.RetriableException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RetryingCallableTest {
    private ExecutorService execService;

    @Before
    public void CreateExecutorService() {
        this.execService = Executors.newSingleThreadExecutor();
    }

    @After
    public void shutDownExecutorService() {
        this.execService.shutdownNow();
    }

    @Test
    public void shouldExecuteNeverFailing() throws InterruptedException, ExecutionException {
        LogInterceptor interceptor = new LogInterceptor(RetryingCallable.class);
        Assertions.assertThat((Integer)((Integer)this.execService.submit(new NeverFailing(0)).get())).isEqualTo(1);
        Assertions.assertThat((boolean)interceptor.containsMessage("Failed with retriable exception")).isFalse();
    }

    @Test
    public void shouldNotRetryWhenCallableDoesNotFail() throws InterruptedException, ExecutionException {
        LogInterceptor interceptor = new LogInterceptor(RetryingCallable.class);
        Assertions.assertThat((Integer)((Integer)this.execService.submit(new NeverFailing(10)).get())).isEqualTo(1);
        Assertions.assertThat((boolean)interceptor.containsMessage("Failed with retriable exception")).isFalse();
    }

    @Test
    public void shouldIgnoreInfiniteRetryWhenCallableDoesNotFail() throws InterruptedException, ExecutionException {
        LogInterceptor interceptor = new LogInterceptor(RetryingCallable.class);
        Assertions.assertThat((Integer)((Integer)this.execService.submit(new NeverFailing(-1)).get())).isEqualTo(1);
        Assertions.assertThat((boolean)interceptor.containsMessage("Failed with retriable exception")).isFalse();
    }

    @Test
    public void shouldRetryAsManyTimesAsRequested() throws InterruptedException {
        LogInterceptor interceptor = new LogInterceptor(RetryingCallable.class);
        LoggingContext.forConnector((String)this.getClass().getSimpleName(), (String)"", (String)"callable");
        TwoTimesFailing failing = new TwoTimesFailing(10);
        try {
            this.execService.submit(failing).get();
        }
        catch (ExecutionException e) {
            Assertions.assertThat((boolean)(e.getCause() instanceof RetriableException)).isTrue();
        }
        Assertions.assertThat((int)failing.calls).isEqualTo(3);
        Assertions.assertThat((long)interceptor.countOccurrences("Failed with retriable exception")).isEqualTo(2L);
    }

    @Test
    public void shouldRetryAsManyTimesAsRequestedWhenAlwaysFails() throws InterruptedException {
        LogInterceptor interceptor = new LogInterceptor(RetryingCallable.class);
        LoggingContext.forConnector((String)this.getClass().getSimpleName(), (String)"", (String)"callable");
        AlwaysFailing failing = new AlwaysFailing(5);
        try {
            this.execService.submit(failing).get();
        }
        catch (ExecutionException e) {
            Assertions.assertThat((boolean)(e.getCause() instanceof RetriableException)).isTrue();
        }
        Assertions.assertThat((int)failing.calls).isEqualTo(6);
        Assertions.assertThat((long)interceptor.countOccurrences("Failed with retriable exception")).isEqualTo(5L);
    }

    @Test
    public void shouldNotRetryWhenRetriesAreDisabled() throws InterruptedException {
        LogInterceptor interceptor = new LogInterceptor(RetryingCallable.class);
        LoggingContext.forConnector((String)this.getClass().getSimpleName(), (String)"", (String)"callable");
        AlwaysFailing failing = new AlwaysFailing(0);
        try {
            this.execService.submit(failing).get();
        }
        catch (ExecutionException e) {
            Assertions.assertThat((boolean)(e.getCause() instanceof RetriableException)).isTrue();
        }
        Assertions.assertThat((int)failing.calls).isEqualTo(1);
        Assertions.assertThat((boolean)interceptor.containsMessage("Failed with retriable exception")).isFalse();
    }

    @Test
    public void shouldKeepRetryingWhenRetryIsInfinite() throws InterruptedException {
        LogInterceptor interceptor = new LogInterceptor(RetryingCallable.class);
        LoggingContext.forConnector((String)this.getClass().getSimpleName(), (String)"", (String)"callable");
        AlwaysFailing failing = new AlwaysFailing(-1);
        this.execService.submit(failing);
        Thread.sleep(3000L);
        this.execService.shutdown();
        Assertions.assertThat((int)failing.calls).isGreaterThan(5);
        Assertions.assertThat((long)interceptor.countOccurrences("Failed with retriable exception")).isGreaterThan(5L);
    }

    private static class NeverFailing
    extends RetryingCallable<Integer> {
        protected volatile int calls = 0;

        NeverFailing(int retries) {
            super(retries);
        }

        public Integer doCall() throws Exception {
            ++this.calls;
            return this.calls;
        }

        public DelayStrategy delayStrategy() {
            return DelayStrategy.linear((Duration)Duration.ofMillis(100L));
        }
    }

    private static class TwoTimesFailing
    extends NeverFailing {
        TwoTimesFailing(int retries) {
            super(retries);
        }

        @Override
        public Integer doCall() throws Exception {
            super.doCall();
            if (this.calls <= 2) {
                throw new RetriableException(String.format("Good try, but I fail this time (call #%s)", this.calls));
            }
            return this.calls;
        }
    }

    private static class AlwaysFailing
    extends NeverFailing {
        AlwaysFailing(int retries) {
            super(retries);
        }

        @Override
        public Integer doCall() throws Exception {
            super.doCall();
            throw new RetriableException("Good try, but I always fail");
        }
    }
}

