/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.connector.simple.SimpleSourceConnector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceRecord;

public class DebeziumAsyncEngineTestUtils {

    public static class AlmostRandomlyFailingDuringStartTask
    extends SimpleSourceConnector.SimpleConnectorTask {
        private static final AtomicInteger taskCounter = new AtomicInteger(0);
        Random rand = new Random();

        public void start(Map<String, String> props) {
            boolean shouldFail = this.rand.nextBoolean();
            int taskCount = taskCounter.incrementAndGet();
            if (taskCount == 1) {
                shouldFail = false;
            }
            if (taskCount == 2) {
                shouldFail = true;
            }
            if (shouldFail) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Unexpected interrupted exception");
                }
                throw new IllegalStateException("Exception during start of the task");
            }
        }
    }

    public static class AlmostRandomlyFailingDuringStartConnector
    extends MultiTaskSimpleSourceConnector {
        public Class<? extends Task> taskClass() {
            return AlmostRandomlyFailingDuringStartTask.class;
        }
    }

    public static class MultiTaskSimpleSourceConnector
    extends SimpleSourceConnector {
        private Map<String, String> config;

        public void start(Map<String, String> props) {
            this.config = props;
        }

        public List<Map<String, String>> taskConfigs(int maxTasks) {
            ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
            for (int i = 0; i < maxTasks; ++i) {
                configs.add(this.config);
            }
            return configs;
        }
    }

    public static class NoOpTask
    extends SimpleSourceConnector.SimpleConnectorTask {
        public List<SourceRecord> poll() throws InterruptedException {
            return new ArrayList<SourceRecord>();
        }
    }

    public static class NoOpConnector
    extends SimpleSourceConnector {
        public Class<? extends Task> taskClass() {
            return NoOpTask.class;
        }
    }

    public static class InterruptedTask
    extends SimpleSourceConnector.SimpleConnectorTask {
        public List<SourceRecord> poll() throws InterruptedException {
            throw new InterruptedException();
        }
    }

    public static class InterruptedConnector
    extends SimpleSourceConnector {
        public Class<? extends Task> taskClass() {
            return InterruptedTask.class;
        }
    }
}

