/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.util.Collect;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;

public class DebeziumEngineTestUtils {
    public static int appendLinesToSource(File inputFile, int numberOfLines, int initLineNumber) throws IOException {
        Object[] lines = new CharSequence[numberOfLines];
        for (int i = 0; i != numberOfLines; ++i) {
            lines[i] = DebeziumEngineTestUtils.generateLine(initLineNumber + i + 1);
        }
        Files.write(inputFile.toPath(), (Iterable<? extends CharSequence>)Collect.arrayListOf((Object[])lines), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        return numberOfLines;
    }

    public static int appendLinesToSource(File inputFile, String linePrefix, int numberOfLines, int initLineNumber) throws IOException {
        Object[] lines = new CharSequence[numberOfLines];
        for (int i = 0; i != numberOfLines; ++i) {
            lines[i] = DebeziumEngineTestUtils.generateLine(linePrefix, initLineNumber + i + 1);
        }
        Files.write(inputFile.toPath(), (Iterable<? extends CharSequence>)Collect.arrayListOf((Object[])lines), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        return numberOfLines;
    }

    public static String generateLine(int lineNumber) {
        return DebeziumEngineTestUtils.generateLine("Generated line number ", lineNumber);
    }

    public static String generateLine(String linePrefix, int lineNumber) {
        return linePrefix + lineNumber;
    }

    public static class FilterPredicate
    implements Predicate<SourceRecord> {
        public ConfigDef config() {
            return new ConfigDef();
        }

        public boolean test(SourceRecord sourceRecord) {
            return sourceRecord.value().equals("Generated line number 1");
        }

        public void close() {
        }

        public void configure(Map<String, ?> map) {
        }
    }

    public static class FilterTransform
    implements Transformation<SourceRecord> {
        public void configure(Map<String, ?> configs) {
        }

        public SourceRecord apply(SourceRecord record) {
            String payload = (String)record.value();
            return payload.equals("Generated line number 1") || payload.equals("Generated line number 2") ? null : record;
        }

        public ConfigDef config() {
            return new ConfigDef();
        }

        public void close() {
        }
    }
}

