/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.simple;

import io.debezium.connector.simple.SimpleSourceConnector;
import io.debezium.document.Array;
import io.debezium.document.ArrayReader;
import io.debezium.document.ArrayWriter;
import io.debezium.document.Document;
import io.debezium.embedded.ConnectorOutputTest;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Iterator;
import java.util.Properties;
import org.apache.kafka.connect.data.Schema;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SimpleSourceConnectorOutputTest
extends ConnectorOutputTest {
    protected static final String TOPIC_NAME = "some-topic";

    @Test
    public void shouldGenerateExpected() throws Exception {
        System.setProperty("debezium.embedded.shutdown.pause.before.interrupt.ms", "5000");
        int numBatches = 1;
        int numRecordsPerBatch = 10;
        Path dir = Testing.Files.createTestingPath((String)"simple/gen-expected").toAbsolutePath();
        Testing.Files.delete((Path)dir);
        Properties config = new Properties();
        config.put("name", "simple-connector-1");
        config.put("connector.class", SimpleSourceConnector.class.getName());
        config.put("tasks.max", "1");
        config.put("batch.count", Integer.toString(numBatches));
        config.put("record.count.per.batch", Integer.toString(numRecordsPerBatch));
        config.put("topic.name", TOPIC_NAME);
        config.put(EmbeddedEngine.WAIT_FOR_COMPLETION_BEFORE_INTERRUPT_MS.name(), String.valueOf(Duration.ofSeconds(1L).toMillis()));
        this.writeConfigurationFileWithDefaultName(dir, config);
        Properties env = new Properties();
        env.put("-connector.timeout.in.seconds", "1");
        this.writeEnvironmentFileWithDefaultName(dir, env);
        Path expectedResults = dir.resolve("expected-records.json");
        Assertions.assertThat((boolean)Files.exists(expectedResults, new LinkOption[0])).isFalse();
        this.runConnector("gen-expected", dir);
        this.assertExpectedRecords(expectedResults, numBatches, numRecordsPerBatch);
        this.appendStop(expectedResults);
        this.cleanOffsetStorage();
        this.runConnector("gen-expected", dir);
        System.clearProperty("debezium.embedded.shutdown.pause.before.interrupt.ms");
    }

    @Test
    public void shouldRunConnectorFromFilesInOneStep() {
        this.runConnector("simple-test-a", "src/test/resources/simple/test/a");
    }

    @Test
    public void shouldRunConnectorFromFilesInTwoSteps() {
        this.runConnector("simple-test-b", "src/test/resources/simple/test/b");
    }

    @Test(expected=AssertionError.class)
    public void shouldRunConnectorFromFilesAndFindMismatch() {
        Testing.Print.disable();
        this.runConnector("simple-test-c", "src/test/resources/simple/test/c");
    }

    @Test
    public void shouldRunConnectorFromFilesInOneStepWithTimestamps() {
        this.runConnector("simple-test-d", "src/test/resources/simple/test/d");
    }

    @Test
    public void shouldRecoverFromRetriableException() {
        this.runConnector("simple-test-e", "src/test/resources/simple/test/e");
    }

    @Test
    public void shouldRecoverFromRetriableExceptionMaxRetriesIs1() {
        this.runConnector("simple-test-f", "src/test/resources/simple/test/f");
    }

    @Test
    public void shouldRecoverFromRetriableExceptionMaxRetriesIsNegative1() {
        this.runConnector("simple-test-g", "src/test/resources/simple/test/g");
    }

    protected void writeConfigurationFileWithDefaultName(Path dir, Properties props) throws IOException {
        Path configFilePath = dir.resolve("connector.properties");
        this.writeConfigurationFile(configFilePath, props);
    }

    protected void writeEnvironmentFileWithDefaultName(Path dir, Properties props) throws IOException {
        Path configFilePath = dir.resolve("env.properties");
        this.writeConfigurationFile(configFilePath, props);
    }

    protected void writeConfigurationFile(Path configFilePath, Properties props) throws IOException {
        File configFile = Testing.Files.createTestingFile((Path)configFilePath);
        try (FileOutputStream ostream = new FileOutputStream(configFile);){
            props.store(ostream, "MockConnector configuration");
        }
    }

    protected Properties readConfiguration(Path configFilePath) throws IOException {
        File configFile = Testing.Files.createTestingFile((Path)configFilePath);
        Properties props = new Properties();
        try (FileInputStream ostream = new FileInputStream(configFile);){
            props.load(ostream);
        }
        return props;
    }

    protected void appendStop(Path results) throws IOException {
        this.appendCommand(results, Document.create((CharSequence)"connector", (Object)"stop"));
    }

    protected Array readResults(File file) throws IOException {
        return ArrayReader.defaultReader().readArray(file);
    }

    protected void appendCommand(Path results, Document command) throws IOException {
        Assertions.assertThat((Object)command).isNotNull();
        Assertions.assertThat((boolean)Files.exists(results, new LinkOption[0])).isTrue();
        Array arrayOfDocuments = this.readResults(results.toFile());
        arrayOfDocuments.add(command);
        try (FileOutputStream stream = new FileOutputStream(results.toFile());){
            ArrayWriter.prettyWriter().write(arrayOfDocuments, (OutputStream)stream);
        }
        if (Testing.Debug.isEnabled()) {
            String content = IoUtil.read((File)results.toFile());
            Testing.debug((Object)("expected results file '" + results + "' after appending command:"));
            Testing.debug((Object)content);
        }
    }

    protected void assertExpectedRecords(Path path, int batchCount, int recordsPerBatch) throws IOException {
        Assertions.assertThat((boolean)Files.exists(path, new LinkOption[0])).isTrue();
        if (Testing.Debug.isEnabled()) {
            String content = IoUtil.read((File)path.toFile());
            Testing.debug((Object)("expected results file '" + path + "':"));
            Testing.debug((Object)content);
        }
        Array expected = this.readResults(path.toFile());
        int expectedId = 0;
        int expectedBatch = 1;
        int expectedRecord = 0;
        Iterator docs = expected.iterator();
        while (docs.hasNext()) {
            Document doc = ((Array.Entry)docs.next()).getValue().asDocument();
            if (doc.has((CharSequence)"connector")) continue;
            ++expectedId;
            if (++expectedRecord > recordsPerBatch) {
                ++expectedBatch;
                expectedRecord = 1;
            }
            Document sourcePartition = doc.getDocument((CharSequence)"sourcePartition");
            Assertions.assertThat((String)sourcePartition.getString((CharSequence)"source")).isEqualTo((Object)"simple");
            Document offset = doc.getDocument((CharSequence)"sourceOffset");
            Assertions.assertThat((Integer)offset.getInteger((CharSequence)"id")).isEqualTo(expectedId);
            Assertions.assertThat((String)doc.getString((CharSequence)"topic")).isEqualTo((Object)TOPIC_NAME);
            Assertions.assertThat((Integer)doc.getInteger((CharSequence)"kafkaPartition")).isEqualTo(1);
            Document key = doc.getDocument((CharSequence)"key");
            Assertions.assertThat((Integer)key.getInteger((CharSequence)"id")).isEqualTo(expectedId);
            Document value = doc.getDocument((CharSequence)"value");
            Assertions.assertThat((Integer)value.getInteger((CharSequence)"batch")).isEqualTo(expectedBatch);
            Assertions.assertThat((Integer)value.getInteger((CharSequence)"record")).isEqualTo(expectedRecord);
            Document keySchema = doc.getDocument((CharSequence)"keySchema");
            Assertions.assertThat((String)keySchema.getString((CharSequence)"name")).isEqualTo((Object)"simple.key");
            Assertions.assertThat((String)keySchema.getString((CharSequence)"type")).isEqualToIgnoringCase((CharSequence)Schema.Type.STRUCT.name());
            Assertions.assertThat((Boolean)keySchema.getBoolean((CharSequence)"optional")).isEqualTo(false);
            Array keySchemaFields = keySchema.getArray((CharSequence)"fields");
            Document keyIdField = keySchemaFields.get(0).asDocument();
            this.assertRequiredFieldSchema(keyIdField, "id", Schema.Type.INT32);
            Document valueSchema = doc.getDocument((CharSequence)"valueSchema");
            Assertions.assertThat((String)valueSchema.getString((CharSequence)"name")).isEqualTo((Object)"simple.value");
            Assertions.assertThat((String)valueSchema.getString((CharSequence)"type")).isEqualToIgnoringCase((CharSequence)Schema.Type.STRUCT.name());
            Assertions.assertThat((Boolean)valueSchema.getBoolean((CharSequence)"optional")).isEqualTo(false);
            Array valueSchemaFields = valueSchema.getArray((CharSequence)"fields");
            Document batchField = valueSchemaFields.get(0).asDocument();
            this.assertRequiredFieldSchema(batchField, "batch", Schema.Type.INT32);
            Document recordField = valueSchemaFields.get(1).asDocument();
            this.assertRequiredFieldSchema(recordField, "record", Schema.Type.INT32);
        }
        Assertions.assertThat((int)expectedBatch).isEqualTo(batchCount);
        Assertions.assertThat((int)expectedId).isEqualTo(batchCount * recordsPerBatch);
    }

    protected void assertFieldSchema(Document doc, String fieldName, Schema.Type type, boolean optional) {
        Assertions.assertThat((String)doc.getString((CharSequence)"field")).isEqualTo((Object)fieldName);
        Assertions.assertThat((String)doc.getString((CharSequence)"type")).isEqualToIgnoringCase((CharSequence)type.name());
        Assertions.assertThat((Boolean)doc.getBoolean((CharSequence)"optional")).isEqualTo(optional);
    }

    protected void assertRequiredFieldSchema(Document doc, String fieldName, Schema.Type type) {
        this.assertFieldSchema(doc, fieldName, type, false);
    }

    protected void assertOptionalFieldSchema(Document doc, String fieldName, Schema.Type type) {
        this.assertFieldSchema(doc, fieldName, type, true);
    }
}

