/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.config.Configuration;
import io.debezium.embedded.Transformations;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.ReplaceField;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.HasHeaderKey;
import org.junit.Assert;
import org.junit.Test;

public class TransformationsTest {
    @Test
    public void test() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("predicates", "hasheader");
        properties.setProperty("predicates.hasheader.type", HasHeaderKey.class.getName());
        properties.setProperty("predicates.hasheader.name", "existingHeader");
        properties.setProperty("transforms", "a,b");
        properties.setProperty("transforms.a.type", ReplaceField.class.getName() + "$Key");
        properties.setProperty("transforms.a.renames", "key:who");
        properties.setProperty("transforms.a.predicate", "hasheader");
        properties.setProperty("transforms.b.type", ReplaceField.class.getName() + "$Key");
        properties.setProperty("transforms.b.renames", "key:pro");
        properties.setProperty("transforms.b.predicate", "hasheader");
        properties.setProperty("transforms.b.negate", "true");
        Configuration configuration = Configuration.from((Properties)properties);
        Schema inputSchema = SchemaBuilder.struct().field("key", Schema.STRING_SCHEMA).build();
        Struct inputStruct = new Struct(inputSchema).put("key", (Object)"b2");
        Schema expectedSchemaA = SchemaBuilder.struct().field("who", Schema.STRING_SCHEMA).build();
        Schema expectedSchemaB = SchemaBuilder.struct().field("pro", Schema.STRING_SCHEMA).build();
        try (Transformations transformations = new Transformations(configuration);){
            Transformation a = transformations.getTransformation("a");
            Assert.assertNotNull((Object)a);
            SourceRecord updated = (SourceRecord)a.apply((ConnectRecord)new SourceRecord(Collections.emptyMap(), Collections.emptyMap(), "t1", Integer.valueOf(1), inputSchema, (Object)inputStruct, inputSchema, (Object)inputStruct, Long.valueOf(System.currentTimeMillis()), (Iterable)new ConnectHeaders().addString("existingHeader", "someValue")));
            Assert.assertEquals((Object)new Struct(expectedSchemaA).put("who", (Object)"b2"), (Object)updated.key());
            a = transformations.getTransformation("a");
            updated = (SourceRecord)a.apply((ConnectRecord)new SourceRecord(Collections.emptyMap(), Collections.emptyMap(), "t1", Integer.valueOf(1), inputSchema, (Object)inputStruct, inputSchema, (Object)inputStruct, Long.valueOf(System.currentTimeMillis()), (Iterable)new ConnectHeaders()));
            Assert.assertEquals((Object)inputStruct, (Object)updated.key());
            Transformation b = transformations.getTransformation("b");
            updated = (SourceRecord)b.apply((ConnectRecord)new SourceRecord(Collections.emptyMap(), Collections.emptyMap(), "t1", Integer.valueOf(1), inputSchema, (Object)inputStruct, inputSchema, (Object)inputStruct, Long.valueOf(System.currentTimeMillis()), (Iterable)new ConnectHeaders()));
            Assert.assertEquals((Object)new Struct(expectedSchemaB).put("pro", (Object)"b2"), (Object)updated.key());
        }
    }
}

