/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.MemorySchemaHistory;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.SchemaHistoryMetrics;
import java.util.Arrays;
import java.util.Collection;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractSchemaHistoryTest
extends AbstractConnectorTest {
    private MemorySchemaHistory schemaHistory;

    @Before
    public void beforeEach() {
        this.schemaHistory = new MemorySchemaHistory();
    }

    @After
    public void afterEach() {
        if (this.schemaHistory != null) {
            this.schemaHistory.stop();
        }
    }

    @Test
    @FixFor(value={"DBZ-4451"})
    public void shouldRecoverRenamedTableWithOnlyTheRenamedEntry() throws Exception {
        this.record(this.getRenameCreateHistoryRecord(), this.getRenameAlterHistoryRecord());
        Tables tables = this.recoverHistory();
        Assertions.assertThat((int)tables.size()).isEqualTo(1);
        Assertions.assertThat((Collection)tables.tableIds()).containsOnly(new Object[]{this.getRenameTableId()});
    }

    protected abstract HistoryRecord getRenameCreateHistoryRecord();

    protected abstract HistoryRecord getRenameAlterHistoryRecord();

    protected abstract TableId getRenameTableId();

    protected abstract Offsets<Partition, OffsetContext> getOffsets();

    protected abstract DdlParser getDdlParser();

    protected Configuration getHistoryConfiguration() {
        return ((Configuration.Builder)Configuration.create().with(SchemaHistory.NAME, "my-db-history")).build();
    }

    protected void record(HistoryRecord ... records) throws Exception {
        Arrays.stream(records).forEach(arg_0 -> ((MemorySchemaHistory)this.schemaHistory).storeRecord(arg_0));
    }

    protected Tables recoverHistory() {
        this.schemaHistory.configure(this.getHistoryConfiguration(), null, SchemaHistoryMetrics.NOOP, true);
        this.schemaHistory.start();
        this.schemaHistory.initializeStorage();
        Tables tables = new Tables();
        this.schemaHistory.recover(this.getOffsets(), tables, this.getDdlParser());
        return tables;
    }
}

